/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.decompiler.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextFactoryKt;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.BuiltInClassesAreSerializableOnJvm;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.utils.concurrent.block.LockedClearableLazyValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u000eH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/KtDecompiledFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "provider", "Lorg/jetbrains/kotlin/idea/decompiler/KotlinDecompiledFileViewProvider;", "buildDecompiledText", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "(Lorg/jetbrains/kotlin/idea/decompiler/KotlinDecompiledFileViewProvider;Lkotlin/jvm/functions/Function1;)V", "decompiledText", "Lorg/jetbrains/kotlin/utils/concurrent/block/LockedClearableLazyValue;", "getDeclarationForDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getRenderedDescriptorsToRange", "", "", "Lcom/intellij/openapi/util/TextRange;", "getText", "onContentReload", "", "findElementForDescriptor", "idea-analysis"})
public class KtDecompiledFile
extends KtFile {
    private final LockedClearableLazyValue<DecompiledText> decompiledText;
    private final KotlinDecompiledFileViewProvider provider;

    @Nullable
    public final KtDeclaration getDeclarationForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor original = descriptor2.getOriginal();
        if (original instanceof ValueParameterDescriptor) {
            CallableDescriptor callable = ((ValueParameterDescriptor)original).getContainingDeclaration();
            KtDeclaration ktDeclaration = this.getDeclarationForDescriptor(callable);
            if (!(ktDeclaration instanceof KtCallableDeclaration)) {
                ktDeclaration = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)ktDeclaration;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration callableDeclaration = ktCallableDeclaration;
            return callableDeclaration.getValueParameters().get(((ValueParameterDescriptor)original).getIndex());
        }
        if (original instanceof ConstructorDescriptor && ((ConstructorDescriptor)original).isPrimary()) {
            KtClassOrObject classOrObject;
            KtDeclarationStub ktDeclarationStub;
            DeclarationDescriptor declarationDescriptor = ((ConstructorDescriptor)original).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"original.containingDeclaration");
            KtDeclaration ktDeclaration = this.getDeclarationForDescriptor(declarationDescriptor);
            if (!(ktDeclaration instanceof KtClassOrObject)) {
                ktDeclaration = null;
            }
            return (ktDeclarationStub = (classOrObject = (KtClassOrObject)ktDeclaration)) != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtDeclaration)ktDeclarationStub : (KtDeclaration)classOrObject;
        }
        KtDeclaration ktDeclaration = this.findElementForDescriptor(original);
        if (ktDeclaration == null) {
            KtDecompiledFile $receiver$iv = this;
            KtDecompiledFile $receiver = $receiver$iv;
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return null;
            }
            FqName classFqName = DescriptorUtilsKt.getFqNameSafe(descriptor2);
            if (BuiltInClassesAreSerializableOnJvm.Companion.isSerializableInJava(classFqName)) {
                ClassDescriptor builtInDescriptor;
                ClassDescriptor classDescriptor = builtInDescriptor = DescriptorUtilsKt.resolveTopLevelClass(TargetPlatform.Default.INSTANCE.getBuiltIns().getBuiltInsModule(), classFqName, NoLookupLocation.FROM_IDE);
                return classDescriptor != null ? $receiver.findElementForDescriptor(classDescriptor) : null;
            }
            return null;
        }
        return ktDeclaration;
    }

    private final KtDeclaration findElementForDescriptor(DeclarationDescriptor $receiver) {
        KtDeclaration ktDeclaration;
        TextRange textRange = this.decompiledText.get().getRenderedDescriptorsToRange().get(DecompiledTextFactoryKt.descriptorToKey($receiver));
        if (textRange != null) {
            TextRange $receiver$iv = textRange;
            TextRange range = $receiver$iv;
            ktDeclaration = (KtDeclaration)PsiTreeUtil.findElementOfClassAtRange((PsiFile)((PsiFile)this), (int)range.getStartOffset(), (int)range.getEndOffset(), KtDeclaration.class);
        } else {
            ktDeclaration = null;
        }
        return ktDeclaration;
    }

    @Nullable
    public String getText() {
        return this.decompiledText.get().getText();
    }

    public void onContentReload() {
        super.onContentReload();
        this.provider.getContent().drop();
        this.decompiledText.drop();
    }

    @NotNull
    public final Map<String, TextRange> getRenderedDescriptorsToRange() {
        return this.decompiledText.get().getRenderedDescriptorsToRange();
    }

    public KtDecompiledFile(@NotNull KotlinDecompiledFileViewProvider provider2, @NotNull Function1<? super VirtualFile, DecompiledText> buildDecompiledText2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)provider2), (String)"provider");
        Intrinsics.checkParameterIsNotNull(buildDecompiledText2, (String)"buildDecompiledText");
        super((FileViewProvider)provider2, true);
        this.provider = provider2;
        this.decompiledText = new LockedClearableLazyValue(new Object(), (Function0)new Function0<DecompiledText>(this, buildDecompiledText2){
            final /* synthetic */ KtDecompiledFile this$0;
            final /* synthetic */ Function1 $buildDecompiledText;

            @NotNull
            public final DecompiledText invoke() {
                VirtualFile virtualFile = KtDecompiledFile.access$getProvider$p(this.this$0).getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"provider.virtualFile");
                return (DecompiledText)this.$buildDecompiledText.invoke((Object)virtualFile);
            }
            {
                this.this$0 = ktDecompiledFile;
                this.$buildDecompiledText = function1;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ KotlinDecompiledFileViewProvider access$getProvider$p(KtDecompiledFile $this) {
        return $this.provider;
    }
}

