/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.RuntimeLibraryFiles;
import org.jetbrains.kotlin.idea.framework.CustomLibraryDescriptorWithDeferredConfig;

public class JSLibraryStdDescription
extends CustomLibraryDescriptorWithDeferredConfig {
    public static final LibraryKind KOTLIN_JAVASCRIPT_KIND = LibraryKind.create((String)"kotlin-js-stdlib");
    public static final String LIBRARY_NAME = "KotlinJavaScript";
    public static final String JAVA_SCRIPT_LIBRARY_CREATION = "JavaScript Library Creation";
    public static final String DIALOG_TITLE = "Create Kotlin JavaScript Library";
    public static final String LIBRARY_CAPTION = "Kotlin JavaScript Library";
    public static final Set<LibraryKind> SUITABLE_LIBRARY_KINDS = Sets.newHashSet((Object[])new LibraryKind[]{KOTLIN_JAVASCRIPT_KIND});

    public JSLibraryStdDescription(@Nullable Project project) {
        super(project, "js", LIBRARY_NAME, DIALOG_TITLE, LIBRARY_CAPTION, KOTLIN_JAVASCRIPT_KIND, SUITABLE_LIBRARY_KINDS);
    }

    public NewLibraryConfiguration createNewLibraryForTests() {
        KotlinJsModuleConfigurator configurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("js");
        assert (configurator != null) : "Cannot find configurator with name js";
        RuntimeLibraryFiles files = configurator.getExistingJarFiles();
        return this.createConfiguration(Collections.singletonList(files.getRuntimeJar()), files.getRuntimeSourcesJar());
    }
}

