/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithGradleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H$J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H$\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getLibFile", "Ljava/io/File;", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "hasLibJarInLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "libraryPath", "", "Companion", "MavenExternalLibraryDescriptor", "idea"})
public abstract class AddKotlinLibQuickFix
extends KotlinQuickFixAction<KtElement> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract String libraryPath();

    @NotNull
    protected abstract File getLibFile();

    protected abstract boolean hasLibJarInLibrary(@NotNull Library var1);

    @NotNull
    protected abstract MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module var1);

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Object v0;
        File libFile;
        block11: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(((KtElement)this.getElement()).getContainingFile().getVirtualFile());
            if (module != null) {
                if (KotlinPluginUtil.isMavenModule(module)) {
                    DependencyScope scope2 = OrderEntryFix.suggestScopeByLocation((Module)module, this.getElement());
                    JavaProjectModelModificationService.getInstance((Project)project).addDependency(module, (ExternalLibraryDescriptor)this.getLibraryDescriptor(module), scope2);
                    return;
                }
                if (KotlinPluginUtil.isGradleModule(module) || KotlinPluginUtil.isAndroidGradleModule(module)) {
                    DependencyScope scope3 = OrderEntryFix.suggestScopeByLocation((Module)module, this.getElement());
                    KotlinWithGradleConfigurator.addKotlinLibraryToModule(module, scope3, this.getLibraryDescriptor(module));
                    return;
                }
            }
            if (!(libFile = this.getLibFile()).exists()) {
                return;
            }
            Object[] objectArray = Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME);
            for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
                void element$iv = $receiver$iv[i];
                if (!(element$iv instanceof KotlinJavaModuleConfigurator)) continue;
                v0 = element$iv;
                break block11;
            }
            v0 = null;
        }
        KotlinJavaModuleConfigurator kotlinJavaModuleConfigurator = v0;
        if (kotlinJavaModuleConfigurator == null) {
            return;
        }
        KotlinJavaModuleConfigurator configurator = kotlinJavaModuleConfigurator;
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        Iterator iterator2 = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile runtimeJar;
            Library library;
            Library library2 = library = (Library)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
            if (KotlinLibraryUtilKt.getRuntimeJar(library2) == null) {
                continue;
            }
            Library library3 = library;
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            if (this.hasLibJarInLibrary(library3)) continue;
            Library.ModifiableModel model = library.getModifiableModel();
            String libFilesDir = VfsUtilCore.virtualToIoFile((VirtualFile)runtimeJar).getParent();
            File libIoFile = new File(libFilesDir, this.libraryPath());
            if (libIoFile.exists()) {
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)libIoFile), OrderRootType.CLASSES);
            } else {
                File copied;
                if (configurator.copyFileToDir(libFile, libFilesDir, collector2) == null) {
                    Intrinsics.throwNpe();
                }
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)copied), OrderRootType.CLASSES);
            }
            model.commit();
        }
        collector2.showNotification();
    }

    public AddKotlinLibQuickFix(@NotNull KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "groupId", "", "artifactId", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLibraryClassesRoots", "", "idea"})
    public static final class MavenExternalLibraryDescriptor
    extends ExternalLibraryDescriptor {
        @NotNull
        public List<String> getLibraryClassesRoots() {
            return CollectionsKt.emptyList();
        }

        public MavenExternalLibraryDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            super(groupId, artifactId, version, version);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$Companion;", "", "()V", "getKotlinStdlibVersion", "", "module", "Lcom/intellij/openapi/module/Module;", "getMavenKotlinStdlibVersion", "idea"})
    public static final class Companion {
        @NotNull
        public final String getKotlinStdlibVersion(@NotNull Module module) {
            String pluginVersion;
            String gradleVersion;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            if (KotlinPluginUtil.isMavenModule(module)) {
                String mavenVersion = this.getMavenKotlinStdlibVersion(module);
                if (mavenVersion != null) {
                    return mavenVersion;
                }
            } else if ((KotlinPluginUtil.isGradleModule(module) || KotlinPluginUtil.isAndroidGradleModule(module)) && (gradleVersion = KotlinWithGradleConfigurator.getKotlinStdlibVersion(module)) != null) {
                return gradleVersion;
            }
            if (Intrinsics.areEqual((Object)"@snapshot@", (Object)(pluginVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion$default(null, 1, null)))) {
                return "0.1-SNAPSHOT";
            }
            return pluginVersion;
        }

        @Nullable
        public final String getMavenKotlinStdlibVersion(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Object[] $receiver$iv = LibrariesContainerFactory.createContainer((Module)module).getAllLibraries();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                Library library = (Library)element$iv;
                String libName = library.getName();
                if (libName == null || !StringsKt.contains$default((CharSequence)libName, (CharSequence)"org.jetbrains.kotlin:kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                return StringsKt.substringAfterLast$default((String)libName, (String)":", null, (int)2, null);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

