/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.KotlinUnusedImportInspection;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "optimizeImportsOnTheFly", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "optimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "runForWholeFile", "scheduleOptimizeImportsOnTheFly", "descriptorsToImport", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "timeToOptimizeImportsOnTheFly", "EnableOptimizeImportsOnTheFlyFix", "OptimizeImportsQuickFix", "idea"})
public final class KotlinUnusedImportInspection
extends AbstractKotlinInspection {
    public boolean runForWholeFile() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (!(file instanceof KtFile) || file instanceof KtCodeFragment) {
            return null;
        }
        if (!((KtFile)file).getManager().isInProject((PsiElement)file)) {
            return null;
        }
        if (((KtFile)file).getImportDirectives().isEmpty()) {
            return null;
        }
        Set<DeclarationDescriptor> descriptorsToImport = KotlinImportOptimizer.Companion.collectDescriptorsToImport((KtFile)file);
        List<KtImportDirective> directives = ((KtFile)file).getImportDirectives();
        Set explicitlyImportedFqNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)directives), (Function1)checkFile.explicitlyImportedFqNames.1.INSTANCE), (Function1)checkFile.explicitlyImportedFqNames.2.INSTANCE), (Function1)checkFile.explicitlyImportedFqNames.3.INSTANCE));
        HashSet<FqName> fqNames = new HashSet<FqName>();
        HashSet<Object> parentFqNames = new HashSet<Object>();
        for (DeclarationDescriptor descriptor2 : descriptorsToImport) {
            Object parentFqName;
            FqName fqName2;
            if (ImportsUtils.getImportableFqName(descriptor2) == null) {
                Intrinsics.throwNpe();
            }
            fqNames.add(fqName2);
            if (!(explicitlyImportedFqNames2.contains(fqName2) ^ true) || ((FqName)(parentFqName = fqName2.parent())).isRoot()) continue;
            parentFqNames.add(parentFqName);
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        HashSet<ImportPath> importPaths = new HashSet<ImportPath>(directives.size());
        for (KtImportDirective ktImportDirective : directives) {
            void $receiver$iv2;
            boolean isUsed;
            ImportPath importPath;
            if (ktImportDirective.getImportPath() == null) {
                continue;
            }
            if (importPath.getAlias() != null || (isUsed = !importPaths.add(importPath) ? false : (importPath.isAllUnder() ? parentFqNames.contains(importPath.fqnPart()) : fqNames.contains(importPath.fqnPart()))) || UtilsKt.targetDescriptors$default(ktImportDirective, null, 1, null).isEmpty()) continue;
            ArrayList fixes2 = CollectionsKt.arrayListOf((Object[])new LocalQuickFix[0]);
            fixes2.add(new OptimizeImportsQuickFix((KtFile)file));
            if (!CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
                fixes2.add(new EnableOptimizeImportsOnTheFlyFix((KtFile)file));
            }
            Collection collection = fixes2;
            boolean bl = isOnTheFly;
            String string = "Unused import directive";
            PsiElement psiElement = (PsiElement)ktImportDirective;
            InspectionManager inspectionManager = manager;
            ArrayList<ProblemDescriptor> arrayList = problems;
            void v0 = $receiver$iv2;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[thisCollection$iv.size()]);
            if (localQuickFixArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = localQuickFixArray;
            arrayList.add(inspectionManager.createProblemDescriptor(psiElement, string, bl, (LocalQuickFix[])objectArray, ProblemHighlightType.LIKE_UNUSED_SYMBOL));
        }
        if (isOnTheFly) {
            this.scheduleOptimizeImportsOnTheFly((KtFile)file, descriptorsToImport);
        }
        Collection collection = problems;
        Collection thisCollection$iv = collection;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[thisCollection$iv.size()]);
        if (problemDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ProblemDescriptor[])((Object[])problemDescriptorArray);
    }

    private final void scheduleOptimizeImportsOnTheFly(KtFile file, Set<? extends DeclarationDescriptor> descriptorsToImport) {
        if (!CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
            return;
        }
        List<ImportPath> list2 = KotlinImportOptimizer.Companion.prepareOptimizedImports(file, (Collection<? extends DeclarationDescriptor>)descriptorsToImport);
        if (list2 == null) {
            return;
        }
        List<ImportPath> optimizedImports = list2;
        Object object = SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)ProgressManager.getInstance().getProgressIndicator(), (Function1)scheduleOptimizeImportsOnTheFly.progress.1.INSTANCE));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator");
        }
        DaemonProgressIndicator progress2 = (DaemonProgressIndicator)object;
        HighlightingSession highlightingSession = HighlightingSessionImpl.getHighlightingSession((PsiFile)((PsiFile)file), (ProgressIndicator)((ProgressIndicator)progress2));
        Project project = highlightingSession.getProject();
        Editor editor = highlightingSession.getEditor();
        if (editor != null) {
            long modificationStamp = editor.getDocument().getModificationStamp();
            Disposable invokeFixLater2 = new Disposable(this, editor, modificationStamp, file, project, optimizedImports){
                final /* synthetic */ KotlinUnusedImportInspection this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ long $modificationStamp;
                final /* synthetic */ KtFile $file;
                final /* synthetic */ Project $project;
                final /* synthetic */ List $optimizedImports;

                public void dispose() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ scheduleOptimizeImportsOnTheFly.invokeFixLater.1 this$0;

                        public final void run() {
                            KotlinUnusedImportInspection kotlinUnusedImportInspection = this.this$0.this$0;
                            KtFile ktFile = this.this$0.$file;
                            Editor editor = this.this$0.$editor;
                            Project project = this.this$0.$project;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                            if (KotlinUnusedImportInspection.access$timeToOptimizeImportsOnTheFly(kotlinUnusedImportInspection, ktFile, editor, project) && this.this$0.$editor.getDocument().getModificationStamp() == this.this$0.$modificationStamp) {
                                KotlinUnusedImportInspection kotlinUnusedImportInspection2 = this.this$0.this$0;
                                KtFile ktFile2 = this.this$0.$file;
                                List list2 = this.this$0.$optimizedImports;
                                Editor editor2 = this.this$0.$editor;
                                Project project2 = this.this$0.$project;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                                KotlinUnusedImportInspection.access$optimizeImportsOnTheFly(kotlinUnusedImportInspection2, ktFile2, list2, editor2, project2);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                    this.$editor = $captured_local_variable$1;
                    this.$modificationStamp = $captured_local_variable$2;
                    this.$file = $captured_local_variable$3;
                    this.$project = $captured_local_variable$4;
                    this.$optimizedImports = $captured_local_variable$5;
                }
            };
            Disposer.register((Disposable)((Disposable)progress2), (Disposable)invokeFixLater2);
            if (progress2.isCanceled()) {
                Disposer.dispose((Disposable)invokeFixLater2);
                Disposer.dispose((Disposable)((Disposable)progress2));
                progress2.checkCanceled();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean timeToOptimizeImportsOnTheFly(KtFile file, Editor editor, Project project) {
        void hasErrors;
        if (project.isDisposed() || !file.isValid() || editor.isDisposed() || !file.isWritable()) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
            return false;
        }
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null || (ktImportList = ktImportList.getTextRange()) == null) {
            return false;
        }
        KtImportList importsRange = ktImportList;
        if (importsRange.containsOffset(editor.getCaretModel().getOffset())) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project);
        if (!codeAnalyzer.isHighlightingAvailable((PsiFile)file)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)file)) {
            return false;
        }
        Document document = editor.getDocument();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document.getTextLength(), (Processor)((Processor)new Processor<HighlightInfo>((TextRange)importsRange, (Ref.BooleanRef)hasErrors){
            final /* synthetic */ TextRange $importsRange;
            final /* synthetic */ Ref.BooleanRef $hasErrors;

            public final boolean process(HighlightInfo highlightInfo) {
                boolean bl;
                if (!this.$importsRange.containsRange(highlightInfo.startOffset, highlightInfo.endOffset)) {
                    this.$hasErrors.element = true;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$importsRange = textRange;
                this.$hasErrors = booleanRef;
            }
        }));
        if (hasErrors.element) {
            return false;
        }
        return DaemonListeners.canChangeFileSilently((PsiFileSystemItem)((PsiFileSystemItem)file));
    }

    private final void optimizeImportsOnTheFly(KtFile file, List<ImportPath> optimizedImports, Editor editor, Project project) {
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(file, optimizedImports, project, editor){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ List $optimizedImports;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;

            public final void run() {
                KotlinImportOptimizer.Companion.replaceImports(this.$file, this.$optimizedImports);
                PsiDocumentManager.getInstance((Project)this.$project).doPostponedOperationsAndUnblockDocument(this.$editor.getDocument());
            }
            {
                this.$file = ktFile;
                this.$optimizedImports = list2;
                this.$project = project;
                this.$editor = editor;
            }
        });
    }

    public static final /* synthetic */ boolean access$timeToOptimizeImportsOnTheFly(KotlinUnusedImportInspection $this, @NotNull KtFile file, @NotNull Editor editor, @NotNull Project project) {
        return $this.timeToOptimizeImportsOnTheFly(file, editor, project);
    }

    public static final /* synthetic */ void access$optimizeImportsOnTheFly(KotlinUnusedImportInspection $this, @NotNull KtFile file, @NotNull List optimizedImports, @NotNull Editor editor, @NotNull Project project) {
        $this.optimizeImportsOnTheFly(file, optimizedImports, editor, project);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$OptimizeImportsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class OptimizeImportsQuickFix
    implements LocalQuickFix {
        private final KtFile file;

        @NotNull
        public String getName() {
            return "Optimize imports";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            new OptimizeImportsProcessor(project, (PsiFile)this.file).run();
        }

        public OptimizeImportsQuickFix(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0016J\u0010\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinUnusedImportInspection$EnableOptimizeImportsOnTheFlyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "kotlin.jvm.PlatformType", "getName", "idea"})
    private static final class EnableOptimizeImportsOnTheFlyFix
    implements LocalQuickFix,
    LowPriorityAction {
        private final KtFile file;

        public String getName() {
            return QuickFixBundle.message((String)"enable.optimize.imports.on.the.fly", (Object[])new Object[0]);
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY = true;
            new OptimizeImportsProcessor(project, (PsiFile)this.file).run();
        }

        public EnableOptimizeImportsOnTheFlyFix(@NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
        }
    }
}

