/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinIntroduceVariableHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u001a\u001a\u0010\f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a&\u0010\r\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u0011\u001a\u00020\b\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\b*\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u0014\u0010\u0019\u001a\u00020\u0015*\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u0014\u0010\u001b\u001a\u00020\u0015*\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u0014\u0010\u001c\u001a\u00020\u0015*\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u001c\u0010\u001e\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u001f\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\f\u0010 \u001a\u00020\u0010*\u0004\u0018\u00010\b\u001a\f\u0010!\u001a\u00020\u0010*\u0004\u0018\u00010\b\u001a\n\u0010\"\u001a\u00020\u0010*\u00020\b\u001a\n\u0010#\u001a\u00020\u0010*\u00020$\u001a\n\u0010%\u001a\u00020\b*\u00020\b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006&"}, d2={"KOTLIN_NULL_PTR_EXCEPTION_FQ", "", "getKOTLIN_NULL_PTR_EXCEPTION_FQ", "()Ljava/lang/String;", "NULL_PTR_EXCEPTION_FQ", "getNULL_PTR_EXCEPTION_FQ", "convertToIfNotNullExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "conditionLhs", "thenClause", "elseClause", "convertToIfNullExpression", "convertToIfStatement", "condition", "evaluatesTo", "", "other", "expressionComparedToNull", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "inlineBaseExpressionIfApplicableWithPrompt", "", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlineIfDeclaredLocallyAndOnlyUsedOnceWithPrompt", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "inlineLeftSideIfApplicableWithPrompt", "inlineReceiverIfApplicableWithPrompt", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "introduceValueForCondition", "occurrenceInThenClause", "isNullExpression", "isNullExpressionOrEmptyBlock", "isStableVariable", "throwsNullPointerExceptionWithNoArguments", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "unwrapBlockOrParenthesis", "idea"})
public final class IfThenUtilsKt {
    @NotNull
    private static final String NULL_PTR_EXCEPTION_FQ = "java.lang.NullPointerException";
    @NotNull
    private static final String KOTLIN_NULL_PTR_EXCEPTION_FQ = "kotlin.KotlinNullPointerException";

    @NotNull
    public static final String getNULL_PTR_EXCEPTION_FQ() {
        return NULL_PTR_EXCEPTION_FQ;
    }

    @NotNull
    public static final String getKOTLIN_NULL_PTR_EXCEPTION_FQ() {
        return KOTLIN_NULL_PTR_EXCEPTION_FQ;
    }

    @Nullable
    public static final KtExpression expressionComparedToNull(KtBinaryExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IElementType operationToken = $receiver.getOperationToken();
        if (Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.EQEQ)) ^ true && Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.EXCLEQ)) ^ true) {
            return null;
        }
        KtExpression ktExpression = $receiver.getRight();
        if (ktExpression == null) {
            return null;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = $receiver.getLeft();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression left = ktExpression2;
        boolean rightIsNull = IfThenUtilsKt.isNullExpression(right);
        boolean leftIsNull = IfThenUtilsKt.isNullExpression(left);
        if (leftIsNull == rightIsNull) {
            return null;
        }
        return leftIsNull ? right : left;
    }

    @NotNull
    public static final KtExpression unwrapBlockOrParenthesis(KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression innerExpression = KtPsiUtil.safeDeparenthesize($receiver);
        if (innerExpression instanceof KtBlockExpression) {
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(((KtBlockExpression)innerExpression).getStatements());
            if (ktExpression == null) {
                return $receiver;
            }
            KtExpression statement2 = ktExpression;
            KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(statement2);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"KtPsiUtil.safeDeparenthesize(statement)");
            return ktExpression2;
        }
        KtExpression ktExpression = innerExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"innerExpression");
        return ktExpression;
    }

    public static final boolean isNullExpression(KtExpression $receiver) {
        KtExpression ktExpression = $receiver;
        return Intrinsics.areEqual(ktExpression != null && (ktExpression = IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression)) != null && (ktExpression = ktExpression.getNode()) != null ? ktExpression.getElementType() : null, (Object)((Object)KtNodeTypes.NULL));
    }

    public static final boolean isNullExpressionOrEmptyBlock(KtExpression $receiver) {
        return IfThenUtilsKt.isNullExpression($receiver) || $receiver instanceof KtBlockExpression && ((KtBlockExpression)$receiver).getStatements().isEmpty();
    }

    public static final boolean throwsNullPointerExceptionWithNoArguments(KtThrowExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression thrownExpression = $receiver.getThrownExpression();
        if (!(thrownExpression instanceof KtCallExpression)) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        KtExpression ktExpression = ((KtCallExpression)thrownExpression).getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression nameExpression = ktNameReferenceExpression;
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, nameExpression);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null || (declarationDescriptor = declarationDescriptor.getContainingDeclaration()) == null) {
            return false;
        }
        DeclarationDescriptor declDescriptor = declarationDescriptor;
        String exceptionName = DescriptorUtils.getFqName(declDescriptor).asString();
        return (Intrinsics.areEqual((Object)exceptionName, (Object)NULL_PTR_EXCEPTION_FQ) || Intrinsics.areEqual((Object)exceptionName, (Object)KOTLIN_NULL_PTR_EXCEPTION_FQ)) && ((KtCallExpression)thrownExpression).getValueArguments().isEmpty();
    }

    public static final boolean evaluatesTo(KtExpression $receiver, @NotNull KtExpression other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)IfThenUtilsKt.unwrapBlockOrParenthesis($receiver).getText(), (Object)other.getText());
    }

    @NotNull
    public static final KtIfExpression convertToIfNotNullExpression(KtExpression $receiver, @NotNull KtExpression conditionLhs, @NotNull KtExpression thenClause, @Nullable KtExpression elseClause) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)conditionLhs, (String)"conditionLhs");
        Intrinsics.checkParameterIsNotNull((Object)thenClause, (String)"thenClause");
        KtExpression condition2 = CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver), "$0 != null", conditionLhs);
        return IfThenUtilsKt.convertToIfStatement($receiver, condition2, thenClause, elseClause);
    }

    @NotNull
    public static final KtIfExpression convertToIfNullExpression(KtExpression $receiver, @NotNull KtExpression conditionLhs, @NotNull KtExpression thenClause) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)conditionLhs, (String)"conditionLhs");
        Intrinsics.checkParameterIsNotNull((Object)thenClause, (String)"thenClause");
        KtExpression condition2 = CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver), "$0 == null", conditionLhs);
        return IfThenUtilsKt.convertToIfStatement$default($receiver, condition2, thenClause, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtIfExpression convertToIfStatement(KtExpression $receiver, @NotNull KtExpression condition2, @NotNull KtExpression thenClause, @Nullable KtExpression elseClause) {
        Object object;
        void newElement$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
        Intrinsics.checkParameterIsNotNull((Object)thenClause, (String)"thenClause");
        PsiElement psiElement = (PsiElement)$receiver;
        PsiElement psiElement2 = (PsiElement)KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver).createIf(condition2, thenClause, elseClause);
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newElement$iv);
        if (result$iv instanceof KtIfExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            object = (KtIfExpression)ktExpression;
        }
        return (KtIfExpression)object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtIfExpression convertToIfStatement$default(KtExpression ktExpression, KtExpression ktExpression2, KtExpression ktExpression3, KtExpression ktExpression4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertToIfStatement");
        }
        if ((n & 4) != 0) {
            ktExpression4 = null;
        }
        return IfThenUtilsKt.convertToIfStatement(ktExpression, ktExpression2, ktExpression3, ktExpression4);
    }

    public static final void introduceValueForCondition(KtIfExpression $receiver, @NotNull KtExpression occurrenceInThenClause, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)occurrenceInThenClause, (String)"occurrenceInThenClause");
        Project project = $receiver.getProject();
        KtExpression ktExpression = $receiver.getCondition();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtExpression ktExpression2 = ((KtBinaryExpression)ktExpression).getLeft();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression occurrenceInConditional = ktExpression2;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        KotlinIntroduceVariableHandler.INSTANCE.doRefactoring(project2, editor, occurrenceInConditional, CollectionsKt.listOf((Object[])new KtExpression[]{occurrenceInConditional, occurrenceInThenClause}), (Function1<? super KtDeclaration, Unit>)((Function1)null));
    }

    public static final void inlineIfDeclaredLocallyAndOnlyUsedOnceWithPrompt(KtNameReferenceExpression $receiver, @Nullable Editor editor) {
        LocalSearchScope scope2;
        Collection references2;
        boolean isLocal;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement = ReferenceUtilKt.getMainReference($receiver).resolve();
        if (!(psiElement instanceof KtProperty)) {
            psiElement = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement;
        if (ktProperty == null) {
            return;
        }
        KtProperty declaration = ktProperty;
        KtElement enclosingElement = KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration);
        boolean bl = isLocal = enclosingElement != null;
        if (!isLocal) {
            return;
        }
        KtElement ktElement = enclosingElement;
        if (ktElement == null) {
            Intrinsics.throwNpe();
        }
        if ((references2 = ReferencesSearch.search((PsiElement)declaration, (SearchScope)((SearchScope)(scope2 = new LocalSearchScope((PsiElement)ktElement)))).findAll()).size() == 1) {
            KotlinInlineValHandler kotlinInlineValHandler = new KotlinInlineValHandler();
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"this.project");
            kotlinInlineValHandler.inlineElement(project, editor, declaration);
        }
    }

    public static final void inlineReceiverIfApplicableWithPrompt(KtSafeQualifiedExpression $receiver, @Nullable Editor editor) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getReceiverExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression != null) {
            IfThenUtilsKt.inlineIfDeclaredLocallyAndOnlyUsedOnceWithPrompt(ktNameReferenceExpression, editor);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public static final void inlineLeftSideIfApplicableWithPrompt(KtBinaryExpression $receiver, @Nullable Editor editor) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getLeft();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression != null) {
            IfThenUtilsKt.inlineIfDeclaredLocallyAndOnlyUsedOnceWithPrompt(ktNameReferenceExpression, editor);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public static final void inlineBaseExpressionIfApplicableWithPrompt(KtPostfixExpression $receiver, @Nullable Editor editor) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getBaseExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression != null) {
            IfThenUtilsKt.inlineIfDeclaredLocallyAndOnlyUsedOnceWithPrompt(ktNameReferenceExpression, editor);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public static final boolean isStableVariable(KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BindingContext context = ResolutionUtils.analyze$default($receiver, null, 1, null);
        VariableDescriptor descriptor2 = BindingContextUtils.extractVariableDescriptorIfAny(context, $receiver, false);
        return descriptor2 instanceof VariableDescriptor && DataFlowValueFactory.isStableValue(descriptor2, DescriptorUtils.getContainingModule(descriptor2));
    }

    static {
        NULL_PTR_EXCEPTION_FQ = NULL_PTR_EXCEPTION_FQ;
        KOTLIN_NULL_PTR_EXCEPTION_FQ = KOTLIN_NULL_PTR_EXCEPTION_FQ;
    }
}

