/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.ui.ColumnInfo;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;

public abstract class KotlinCallableParameterTableModel
extends ParameterTableModelBase<KotlinParameterInfo, ParameterTableModelItemBase<KotlinParameterInfo>> {
    private final Project project;
    private final KotlinMethodDescriptor methodDescriptor;

    protected KotlinCallableParameterTableModel(KotlinMethodDescriptor methodDescriptor, PsiElement context, ColumnInfo ... columnInfos) {
        super(context, context, columnInfos);
        this.methodDescriptor = methodDescriptor;
        this.project = context.getProject();
    }

    @Nullable
    public KotlinParameterInfo getReceiver() {
        return null;
    }

    protected ParameterTableModelItemBase<KotlinParameterInfo> createRowItem(@Nullable KotlinParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new KotlinParameterInfo(this.methodDescriptor.getBaseDescriptor(), -1, "", new KotlinTypeInfo(false, null, null), null, null, KotlinValVar.None, null);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(this.project);
        KtTypeCodeFragment paramTypeCodeFragment = psiFactory.createTypeCodeFragment(KotlinTypeInfoKt.render(parameterInfo.getCurrentTypeInfo()), this.myTypeContext);
        KtExpression defaultValueForCall = parameterInfo.getDefaultValueForCall();
        KtExpressionCodeFragment defaultValueCodeFragment = psiFactory.createExpressionCodeFragment(defaultValueForCall != null ? defaultValueForCall.getText() : "", this.myDefaultValueContext);
        return new ParameterTableModelItemBase<KotlinParameterInfo>(parameterInfo, (PsiCodeFragment)paramTypeCodeFragment, (PsiCodeFragment)defaultValueCodeFragment){

            public boolean isEllipsisType() {
                return false;
            }
        };
    }

    public static boolean isTypeColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.TypeColumn;
    }

    public static boolean isNameColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.NameColumn;
    }

    public static boolean isDefaultValueColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.DefaultValueColumn;
    }
}

