/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRunningReadTask<RequestInfo, ResultData> {
    private ProgressIndicator progressIndicator = null;
    private RequestInfo requestInfo = null;
    private State currentState = State.NOT_INITIALIZED;

    protected LongRunningReadTask() {
    }

    public boolean shouldStart(@Nullable LongRunningReadTask<RequestInfo, ResultData> previousTask) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.currentState != State.INITIALIZED) {
            throw new IllegalStateException("Task should be initialized state. Call init() method.");
        }
        if (!(previousTask == null || previousTask.currentState != State.STARTED || this.requestInfo != null && this.requestInfo.equals(previousTask.requestInfo))) {
            previousTask.progressIndicator.cancel();
        }
        if (this.requestInfo == null) {
            if (previousTask != null && (previousTask.currentState == State.FINISHED_WITH_ACTUAL_DATA || previousTask.currentState == State.FINISHED)) {
                previousTask.hideResultOnInvalidLocation();
            }
            return false;
        }
        if (previousTask != null) {
            if (previousTask.currentState == State.STARTED) {
                return !this.requestInfo.equals(previousTask.requestInfo);
            }
            if (previousTask.currentState == State.FINISHED_WITH_ACTUAL_DATA && this.requestInfo.equals(previousTask.requestInfo)) {
                return false;
            }
        }
        return true;
    }

    public final void run() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.currentState != State.INITIALIZED) {
            throw new IllegalStateException("Task should be initialized with init() method");
        }
        if (this.requestInfo == null) {
            throw new IllegalStateException("Invalid request for task beginning");
        }
        this.currentState = State.STARTED;
        this.beforeRun();
        this.progressIndicator = new ProgressIndicatorBase();
        final RequestInfo requestInfoCopy = this.cloneRequestInfo(this.requestInfo);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                LongRunningReadTask.runWithWriteActionPriority(LongRunningReadTask.this.progressIndicator, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object finalResult;
                        Object resultData = null;
                        try {
                            finalResult = resultData = LongRunningReadTask.this.processRequest(requestInfoCopy);
                        }
                        catch (Throwable throwable) {
                            Object finalResult2 = resultData;
                            ApplicationManager.getApplication().invokeLater(new Runnable(finalResult2){
                                final /* synthetic */ Object val$finalResult;
                                {
                                    this.val$finalResult = object;
                                }

                                @Override
                                public void run() {
                                    LongRunningReadTask.this.resultReady(this.val$finalResult);
                                }
                            });
                            throw throwable;
                        }
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            }
        });
    }

    public final boolean init() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.requestInfo = this.prepareRequestInfo();
        this.currentState = State.INITIALIZED;
        return this.requestInfo != null;
    }

    private void resultReady(ResultData resultData) {
        RequestInfo actualInfo;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.currentState = State.FINISHED;
        if (resultData != null && this.requestInfo.equals(actualInfo = this.prepareRequestInfo())) {
            this.currentState = State.FINISHED_WITH_ACTUAL_DATA;
            this.onResultReady(actualInfo, resultData);
        }
    }

    @NotNull
    protected RequestInfo cloneRequestInfo(@NotNull RequestInfo requestInfo) {
        if (requestInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestInfo", "org/jetbrains/kotlin/idea/util/LongRunningReadTask", "cloneRequestInfo"));
        }
        RequestInfo cloneRequestInfo = this.prepareRequestInfo();
        if (cloneRequestInfo == null) {
            throw new IllegalStateException("Cloned request object can't be null");
        }
        RequestInfo RequestInfo = cloneRequestInfo;
        if (RequestInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/util/LongRunningReadTask", "cloneRequestInfo"));
        }
        return RequestInfo;
    }

    @Nullable
    protected abstract RequestInfo prepareRequestInfo();

    protected void hideResultOnInvalidLocation() {
    }

    protected void beforeRun() {
    }

    @Nullable
    protected abstract ResultData processRequest(@NotNull RequestInfo var1);

    protected void onResultReady(@NotNull RequestInfo requestInfo, @Nullable ResultData resultData) {
        if (requestInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestInfo", "org/jetbrains/kotlin/idea/util/LongRunningReadTask", "onResultReady"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithWriteActionPriority(final @NotNull ProgressIndicator indicator, final @NotNull Runnable action2) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/idea/util/LongRunningReadTask", "runWithWriteActionPriority"));
        }
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/idea/util/LongRunningReadTask", "runWithWriteActionPriority"));
        }
        ApplicationAdapter listener2 = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action2) {
                indicator.cancel();
            }
        };
        final Application application = ApplicationManager.getApplication();
        try {
            application.addApplicationListener((ApplicationListener)listener2);
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    application.runReadAction(action2);
                }
            }, indicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener2);
        }
    }

    static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        STARTED,
        FINISHED,
        FINISHED_WITH_ACTUAL_DATA;

    }
}

