/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtIfExpression
extends KtExpressionImpl {
    public KtIfExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtIfExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtIfExpression", "accept"));
        }
        return visitor2.visitIfExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getCondition() {
        return this.findExpressionUnder(KtNodeTypes.CONDITION);
    }

    @IfNotParsed
    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(KtTokens.LPAR);
    }

    @IfNotParsed
    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public KtExpression getThen() {
        return this.findExpressionUnder(KtNodeTypes.THEN);
    }

    @Nullable
    public KtExpression getElse() {
        return this.findExpressionUnder(KtNodeTypes.ELSE);
    }

    @Nullable
    public PsiElement getElseKeyword() {
        return this.findChildByType(KtTokens.ELSE_KEYWORD);
    }

    @NotNull
    public PsiElement getIfKeyword() {
        PsiElement psiElement = this.findChildByType(KtTokens.IF_KEYWORD);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtIfExpression", "getIfKeyword"));
        }
        return psiElement;
    }
}

