/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.PsiElementPlaceholderArgumentType;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/psi/PsiChildRangeArgumentType;", "Lorg/jetbrains/kotlin/psi/PsiElementPlaceholderArgumentType;", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "replacePlaceholderElement", "", "placeholder", "argument", "frontend"})
final class PsiChildRangeArgumentType
extends PsiElementPlaceholderArgumentType<PsiChildRange, KtElement> {
    public static final PsiChildRangeArgumentType INSTANCE;

    @Override
    public void replacePlaceholderElement(@NotNull KtElement placeholder, @NotNull PsiChildRange argument2) {
        Intrinsics.checkParameterIsNotNull((Object)placeholder, (String)"placeholder");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Project project = placeholder.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if (argument2.isEmpty()) {
            placeholder.delete();
        } else {
            PsiElement psiElement = placeholder.getParent();
            PsiElement psiElement2 = argument2.getFirst();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement3 = argument2.getLast();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement first = psiElement.addRangeBefore(psiElement2, psiElement3, (PsiElement)placeholder);
            PsiElement last = placeholder.getPrevSibling();
            placeholder.delete();
            codeStyleManager.reformatNewlyAddedElement(first.getNode().getTreeParent(), first.getNode());
            if (Intrinsics.areEqual((Object)last, (Object)first) ^ true) {
                codeStyleManager.reformatNewlyAddedElement(last.getNode().getTreeParent(), last.getNode());
            }
        }
    }

    private PsiChildRangeArgumentType() {
        super(PsiChildRange.class, KtElement.class);
        INSTANCE = this;
    }

    static {
        new PsiChildRangeArgumentType();
    }
}

