/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinImportDirectiveStubImpl;

public class KtImportDirectiveElementType
extends KtStubElementType<KotlinImportDirectiveStub, KtImportDirective> {
    public KtImportDirectiveElementType(@NotNull @NonNls String debugName2) {
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "<init>"));
        }
        super(debugName2, KtImportDirective.class, KotlinImportDirectiveStub.class);
    }

    public KotlinImportDirectiveStub createStub(@NotNull KtImportDirective psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "createStub"));
        }
        FqName importedFqName = psi.getImportedFqName();
        StringRef fqName2 = StringRef.fromString((String)(importedFqName == null ? null : importedFqName.asString()));
        StringRef aliasName = StringRef.fromString((String)psi.getAliasName());
        return new KotlinImportDirectiveStubImpl((StubElement<PsiElement>)parentStub, psi.isAbsoluteInRootPackage(), psi.isAllUnder(), fqName2, aliasName, psi.isValidImport());
    }

    public void serialize(@NotNull KotlinImportDirectiveStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "serialize"));
        }
        dataStream.writeBoolean(stub.isAbsoluteInRootPackage());
        dataStream.writeBoolean(stub.isAllUnder());
        FqName importedFqName = stub.getImportedFqName();
        dataStream.writeName(importedFqName != null ? importedFqName.asString() : null);
        dataStream.writeName(stub.getAliasName());
        dataStream.writeBoolean(stub.isValid());
    }

    @NotNull
    public KotlinImportDirectiveStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "deserialize"));
        }
        boolean isAbsoluteInRootPackage = dataStream.readBoolean();
        boolean isAllUnder = dataStream.readBoolean();
        StringRef importedName = dataStream.readName();
        StringRef aliasName = dataStream.readName();
        boolean isValid2 = dataStream.readBoolean();
        KotlinImportDirectiveStubImpl kotlinImportDirectiveStubImpl = new KotlinImportDirectiveStubImpl((StubElement<PsiElement>)parentStub, isAbsoluteInRootPackage, isAllUnder, importedName, aliasName, isValid2);
        if (kotlinImportDirectiveStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType", "deserialize"));
        }
        return kotlinImportDirectiveStubImpl;
    }
}

