/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;
import org.jetbrains.plugins.javaFX.indexing.JavaFxIdsIndex;

public class JavaFxImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitWrite(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (element instanceof PsiField) {
            Project project;
            List<VirtualFile> fxmls;
            String qualifiedName;
            String name = ((PsiField)element).getName();
            PsiClass containingClass = ((PsiField)element).getContainingClass();
            if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null && !(fxmls = JavaFxControllerClassIndex.findFxmlsWithController(project = element.getProject(), qualifiedName)).isEmpty()) {
                Collection<String> filePaths = JavaFxIdsIndex.getFilePaths(project, name);
                for (VirtualFile fxml : fxmls) {
                    if (!filePaths.contains(fxml.getPath())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

