/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class JavaFxLocationReferenceProvider
extends PsiReferenceProvider {
    private boolean mySupportCommaInValue = false;
    private final FileType[] myAcceptedFileTypes;

    JavaFxLocationReferenceProvider() {
        this(false, new String[0]);
    }

    JavaFxLocationReferenceProvider(boolean supportCommaInValue, String ... acceptedFileTypes) {
        this.mySupportCommaInValue = supportCommaInValue;
        this.myAcceptedFileTypes = new FileType[acceptedFileTypes.length];
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        for (int i = 0; i < acceptedFileTypes.length; ++i) {
            this.myAcceptedFileTypes[i] = fileTypeManager.getFileTypeByExtension(acceptedFileTypes[i]);
        }
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        String value = ((XmlAttributeValue)element).getValue();
        if (value.startsWith("@")) {
            FileReference[] fileReferenceArray = new FileReferenceSet(value.substring(1), element, 2, null, true).getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
            }
            return fileReferenceArray;
        }
        if (this.mySupportCommaInValue && value.contains(",")) {
            int startIdx = 0;
            int endIdx = 0;
            ArrayList refs = new ArrayList();
            do {
                Collections.addAll(refs, JavaFxLocationReferenceProvider.collectRefs(element, (endIdx = value.indexOf(",", startIdx)) >= 0 ? value.substring(startIdx, endIdx) : value.substring(startIdx), startIdx + 1, this.myAcceptedFileTypes));
                startIdx = endIdx + 1;
            } while (endIdx >= 0);
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = JavaFxLocationReferenceProvider.collectRefs(element, value, 1, this.myAcceptedFileTypes);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] collectRefs(@NotNull PsiElement element, String value, int startInElement, final FileType ... acceptedFileTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "collectRefs"));
        }
        FileReferenceSet set = new FileReferenceSet(value, element, startInElement, null, true){

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return new Condition<PsiFileSystemItem>(){

                    public boolean value(PsiFileSystemItem item) {
                        if (item instanceof PsiDirectory) {
                            return true;
                        }
                        VirtualFile virtualFile = item.getVirtualFile();
                        if (virtualFile == null) {
                            return false;
                        }
                        FileType fileType = virtualFile.getFileType();
                        return ArrayUtilRt.find((Object[])acceptedFileTypes, (Object)fileType) >= 0;
                    }
                };
            }
        };
        if (value.startsWith("/")) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return set.getAllReferences();
    }
}

