/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ConsumerAvailable;
import org.gradle.messaging.remote.internal.protocol.ConsumerUnavailable;
import org.gradle.messaging.remote.internal.protocol.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastSendProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastSendProtocol.class);
    private ProtocolContext<Message> context;
    private final Set<Object> consumers = new HashSet<Object>();
    private final List<Object> queue = new ArrayList<Object>();
    private boolean stopping;

    @Override
    public void start(ProtocolContext<Message> context) {
        this.context = context;
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof Request) {
            Request request = (Request)message;
            if (this.consumers.isEmpty()) {
                this.queue.add(request.getPayload());
            } else {
                for (Object consumer : this.consumers) {
                    this.context.dispatchOutgoing(new Request(consumer, request.getPayload()));
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("Unexpected outgoing message dispatched: %s", message));
        }
    }

    @Override
    public void handleIncoming(Message message) {
        if (message instanceof ConsumerAvailable) {
            ConsumerAvailable consumerAvailable = (ConsumerAvailable)message;
            this.consumers.add(consumerAvailable.getId());
            if (!this.queue.isEmpty()) {
                for (Object queued : this.queue) {
                    this.context.dispatchOutgoing(new Request(consumerAvailable.getId(), queued));
                }
                this.queue.clear();
                if (this.stopping) {
                    LOGGER.debug("All queued outgoing messages have been dispatched. Stopping now.");
                    this.context.stopped();
                }
            }
        } else if (message instanceof ConsumerUnavailable) {
            ConsumerUnavailable consumerUnavailable = (ConsumerUnavailable)message;
            this.consumers.remove(consumerUnavailable.getId());
        } else {
            throw new IllegalArgumentException(String.format("Received unexpected incoming message: %s", message));
        }
    }

    @Override
    public void stopRequested() {
        if (this.queue.isEmpty()) {
            LOGGER.debug("No outgoing messages queued. Stopping now.");
            this.context.stopped();
            return;
        }
        LOGGER.debug("Outgoing messages queued. Stopping later.");
        this.stopping = true;
        this.context.stopLater();
        this.context.callbackLater(5, TimeUnit.SECONDS, new Runnable(){

            public void run() {
                LOGGER.debug("Timeout waiting for queued messages to be dispatched. Stopping now.");
                BroadcastSendProtocol.this.queue.clear();
                BroadcastSendProtocol.this.context.stopped();
            }
        });
    }
}

