/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.sources;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.repository.sources.SdkAddonSource;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSourceCategory;
import com.android.sdklib.internal.repository.sources.SdkSysImgSource;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class SdkSources {
    private static final String KEY_COUNT = "count";
    private static final String KEY_SRC = "src";
    private static final String SRC_FILENAME = "repositories.cfg";
    private final EnumMap<SdkSourceCategory, ArrayList<SdkSource>> mSources = new EnumMap(SdkSourceCategory.class);
    private ArrayList<Runnable> mChangeListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SdkSourceCategory category, SdkSource source) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> list = this.mSources.get(category);
            if (list == null) {
                list = new ArrayList();
                this.mSources.put(category, list);
            }
            list.add(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SdkSource source) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            Iterator<Map.Entry<SdkSourceCategory, ArrayList<SdkSource>>> it = this.mSources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry = it.next();
                ArrayList<SdkSource> list = entry.getValue();
                if (!list.remove(source) || !list.isEmpty()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            this.mSources.remove(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSourceCategory[] getCategories() {
        ArrayList<SdkSourceCategory> cats = new ArrayList<SdkSourceCategory>();
        for (SdkSourceCategory cat : SdkSourceCategory.values()) {
            if (cat.getAlwaysDisplay()) {
                cats.add(cat);
                continue;
            }
            EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
            synchronized (enumMap) {
                ArrayList<SdkSource> list = this.mSources.get(cat);
                if (list != null && !list.isEmpty()) {
                    cats.add(cat);
                }
            }
        }
        return cats.toArray(new SdkSourceCategory[cats.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getSources(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> list = this.mSources.get(category);
            if (list == null) {
                return new SdkSource[0];
            }
            return list.toArray(new SdkSource[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSources(SdkSourceCategory category) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> list = this.mSources.get(category);
            return list != null && !list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSource[] getAllSources() {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            int n = 0;
            for (ArrayList<SdkSource> list : this.mSources.values()) {
                n += list.size();
            }
            SdkSource[] sources = new SdkSource[n];
            int i = 0;
            for (ArrayList<SdkSource> list : this.mSources.values()) {
                for (SdkSource source : list) {
                    sources[i++] = source;
                }
            }
            return sources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllPackages() {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            for (ArrayList<SdkSource> list : this.mSources.values()) {
                for (SdkSource source : list) {
                    source.clearPackages();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdkSourceCategory getCategory(SdkSource source) {
        if (source != null) {
            EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
            synchronized (enumMap) {
                for (Map.Entry<SdkSourceCategory, ArrayList<SdkSource>> entry : this.mSources.entrySet()) {
                    if (!entry.getValue().contains(source)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSourceUrl(SdkSource source) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            for (ArrayList<SdkSource> list : this.mSources.values()) {
                for (SdkSource s : list) {
                    if (!s.equals(source)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSourceUrl(SdkSourceCategory category, SdkSource source) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            ArrayList<SdkSource> list = this.mSources.get(category);
            if (list != null) {
                for (SdkSource s : list) {
                    if (!s.equals(source)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserAddons(ILogger log) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            this.removeAll(SdkSourceCategory.USER_ADDONS);
            FileInputStream fis = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SRC_FILENAME);
                if (f.exists()) {
                    fis = new FileInputStream(f);
                    Properties props = new Properties();
                    props.load(fis);
                    int count = Integer.parseInt(props.getProperty(KEY_COUNT, "0"));
                    for (int i = 0; i < count; ++i) {
                        SdkSource s;
                        String url = props.getProperty(String.format("%s%02d", KEY_SRC, i));
                        if (url == null || this.hasSourceUrl(s = url.endsWith("sys-img.xml") ? new SdkSysImgSource(url, null) : new SdkAddonSource(url, null))) continue;
                        this.add(SdkSourceCategory.USER_ADDONS, s);
                    }
                }
            }
            catch (NumberFormatException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (IOException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.notifyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserAddons(ILogger log) {
        EnumMap<SdkSourceCategory, ArrayList<SdkSource>> enumMap = this.mSources;
        synchronized (enumMap) {
            FileOutputStream fos = null;
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SRC_FILENAME);
                fos = new FileOutputStream(f);
                Properties props = new Properties();
                int count = 0;
                for (SdkSource s : this.getSources(SdkSourceCategory.USER_ADDONS)) {
                    props.setProperty(String.format("%s%02d", KEY_SRC, count), s.getUrl());
                    ++count;
                }
                props.setProperty(KEY_COUNT, Integer.toString(count));
                props.store(fos, "## User Sources for Android SDK Manager");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            catch (IOException e) {
                log.error((Throwable)e, null, new Object[0]);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(Runnable changeListener) {
        assert (changeListener != null);
        if (this.mChangeListeners == null) {
            this.mChangeListeners = new ArrayList();
        }
        ArrayList<Runnable> arrayList = this.mChangeListeners;
        synchronized (arrayList) {
            if (changeListener != null && !this.mChangeListeners.contains(changeListener)) {
                this.mChangeListeners.add(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(Runnable changeListener) {
        if (this.mChangeListeners != null && changeListener != null) {
            ArrayList<Runnable> arrayList = this.mChangeListeners;
            synchronized (arrayList) {
                this.mChangeListeners.remove(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChangeListeners() {
        if (this.mChangeListeners == null) {
            return;
        }
        ArrayList<Runnable> arrayList = this.mChangeListeners;
        synchronized (arrayList) {
            for (Runnable runnable : this.mChangeListeners) {
                try {
                    runnable.run();
                }
                catch (Throwable ignore) {
                    assert (ignore == null) : "A SdkSource.ChangeListener failed with an exception: " + ignore.toString();
                }
            }
        }
    }
}

