/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntFileDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import icons.AntIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomFileDescription
extends AntFileDescription<AntDomProject> {
    private static final String ROOT_TAG_NAME = "project";

    public AntDomFileDescription() {
        super(AntDomProject.class, ROOT_TAG_NAME);
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ant/dom/AntDomFileDescription", "isMyFile"));
        }
        return super.isMyFile(file, module) && AntDomFileDescription.isAntFile(file);
    }

    @Nullable
    public Icon getFileIcon(@Iconable.IconFlags int flags) {
        return AntIcons.AntBuildXml;
    }

    public static boolean isAntFile(XmlFile xmlFile) {
        XmlDocument document = xmlFile.getDocument();
        if (document != null) {
            XmlTag tag = document.getRootTag();
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (tag != null && ROOT_TAG_NAME.equals(tag.getName()) && tag.getContext() instanceof XmlDocument && tag.getAttributeValue("name") != null && tag.getAttributeValue("default") != null && vFile != null && ForcedAntFileAttribute.mayBeAntFile(vFile)) {
                return true;
            }
            if (vFile != null && ForcedAntFileAttribute.isAntFile(vFile)) {
                return true;
            }
        }
        return false;
    }
}

