/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomFileReferenceSet;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntPathConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    private final boolean myShouldValidateRefs;

    public AntPathConverter() {
        this(false);
    }

    protected AntPathConverter(boolean validateRefs) {
        this.myShouldValidateRefs = validateRefs;
    }

    public PsiFileSystemItem fromString(@Nullable @NonNls String s, ConvertContext context) {
        VirtualFile vFile;
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        String path = attribValue.getStringValue();
        if (path == null) {
            path = this.getAttributeDefaultValue(context, attribValue);
        }
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            AntDomProject antProject = this.getEffectiveAntProject(attribValue);
            if (antProject == null) {
                return null;
            }
            file = new File(this.getPathResolveRoot(context, antProject), path);
        }
        if ((vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)file.getAbsolutePath()))) == null) {
            return null;
        }
        PsiManager psiManager = context.getPsiManager();
        return vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
    }

    protected AntDomProject getEffectiveAntProject(GenericAttributeValue attribValue) {
        AntDomProject project = (AntDomProject)attribValue.getParentOfType(AntDomProject.class, false);
        if (project != null) {
            project = project.getContextAntProject();
        }
        return project;
    }

    @Nullable
    protected String getPathResolveRoot(ConvertContext context, AntDomProject antProject) {
        return antProject.getProjectBasedirPath();
    }

    @Nullable
    protected String getAttributeDefaultValue(ConvertContext context, GenericAttributeValue attribValue) {
        return null;
    }

    public String toString(@Nullable PsiFileSystemItem file, ConvertContext context) {
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        return attribValue.getRawText();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        GenericAttributeValue attrib;
        if (genericDomValue instanceof GenericAttributeValue && (attrib = (GenericAttributeValue)genericDomValue).getRawText() != null) {
            AntDomFileReferenceSet refSet = new AntDomFileReferenceSet(attrib, this.myShouldValidateRefs);
            FileReference[] fileReferenceArray = refSet.getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntPathConverter", "createReferences"));
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntPathConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

