/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.states;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.states.NotFailedState;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.SuiteState;
import com.intellij.execution.testframework.Printable;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TestState
implements Printable {
    public static final TestState DEFAULT = new NotFailedState(2, false);
    public static final TestState RUNNING_STATE = new NotFailedState(3, false);
    protected int myMagnitude;

    public List<TestProxy> getAllTestsOf(TestProxy test) {
        ArrayList<TestProxy> allTests = new ArrayList<TestProxy>();
        test.collectAllTestsTo(allTests);
        return allTests;
    }

    public abstract int getMagnitude();

    public abstract boolean isFinal();

    public boolean isDefect() {
        return false;
    }

    public boolean isInProgress() {
        return !this.isFinal();
    }

    public Statistics getStatisticsFor(TestProxy test) {
        return test.getStatisticsImpl();
    }

    public void update() {
    }

    public void merge(@NotNull TestState state, TestProxy parent) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/junit2/states/TestState", "merge"));
        }
    }

    public boolean isPassed() {
        return this.getMagnitude() == 1;
    }

    public Navigatable getDescriptor(Location<?> location) {
        if (location != null) {
            return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
        }
        return null;
    }

    public void changeStateAfterAddingChildTo(TestProxy test, TestProxy child) {
        test.setState(new SuiteState(test));
    }
}

