/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class SynchronizedToolingImplementationLoader
implements ToolingImplementationLoader,
Closeable {
    private final Lock lock = new ReentrantLock();
    private final ToolingImplementationLoader delegate;

    public SynchronizedToolingImplementationLoader(ToolingImplementationLoader delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
        if (this.lock.tryLock()) {
            try {
                ConsumerConnection consumerConnection = this.delegate.create(distribution, progressLoggerFactory, connectionParameters, cancellationToken);
                return consumerConnection;
            }
            finally {
                this.lock.unlock();
            }
        }
        ProgressLogger logger = progressLoggerFactory.newOperation(SynchronizedToolingImplementationLoader.class);
        logger.setDescription("Wait for the other thread to finish acquiring the distribution");
        logger.started();
        this.lock.lock();
        try {
            ConsumerConnection consumerConnection = this.delegate.create(distribution, progressLoggerFactory, connectionParameters, cancellationToken);
            return consumerConnection;
        }
        finally {
            this.lock.unlock();
            logger.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.delegate}).stop();
        }
        finally {
            this.lock.unlock();
        }
    }
}

