/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.internal.DefaultFinishEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.internal.DefaultOperationFailureResult;
import org.gradle.tooling.events.internal.DefaultOperationSuccessResult;
import org.gradle.tooling.events.internal.DefaultStartEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskFailureResult;
import org.gradle.tooling.events.task.internal.DefaultTaskFinishEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskOperationDescriptor;
import org.gradle.tooling.events.task.internal.DefaultTaskSkippedResult;
import org.gradle.tooling.events.task.internal.DefaultTaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskSuccessResult;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultJvmTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestFailureResult;
import org.gradle.tooling.events.test.internal.DefaultTestFinishEvent;
import org.gradle.tooling.events.test.internal.DefaultTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestSkippedResult;
import org.gradle.tooling.events.test.internal.DefaultTestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultTestSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.events.InternalFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationResult;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTestFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestResult;
import org.gradle.tooling.internal.protocol.events.InternalTestSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTestStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestSuccessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildProgressListenerAdapter
implements InternalBuildProgressListener {
    private final ListenerBroadcast<ProgressListener> testProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> taskProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> buildOperationProgressListeners = new ListenerBroadcast(ProgressListener.class);
    private final Map<Object, OperationDescriptor> descriptorCache = new HashMap<Object, OperationDescriptor>();

    BuildProgressListenerAdapter(List<ProgressListener> testProgressListeners, List<ProgressListener> taskProgressListeners, List<ProgressListener> buildOperationProgressListeners) {
        this.testProgressListeners.addAll(testProgressListeners);
        this.taskProgressListeners.addAll(taskProgressListeners);
        this.buildOperationProgressListeners.addAll(buildOperationProgressListeners);
    }

    @Override
    public List<String> getSubscribedOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (!this.testProgressListeners.isEmpty()) {
            operations.add("TEST_EXECUTION");
        }
        if (!this.taskProgressListeners.isEmpty()) {
            operations.add("TASK_EXECUTION");
        }
        if (!this.buildOperationProgressListeners.isEmpty()) {
            operations.add("BUILD_EXECUTION");
        }
        return operations;
    }

    @Override
    public void onEvent(Object event) {
        this.doBroadcast(event);
    }

    private void doBroadcast(Object event) {
        if (event instanceof InternalTestProgressEvent) {
            InternalTestProgressEvent progressEvent = (InternalTestProgressEvent)event;
            this.broadcastTestProgressEvent(progressEvent);
        } else if (event instanceof InternalProgressEvent) {
            InternalProgressEvent progressEvent = (InternalProgressEvent)event;
            if (progressEvent.getDescriptor() instanceof InternalTaskDescriptor) {
                this.broadcastTaskProgressEvent(progressEvent);
            } else {
                this.broadcastProgressEvent(progressEvent);
            }
        }
    }

    private void broadcastTestProgressEvent(InternalTestProgressEvent event) {
        TestProgressEvent testProgressEvent = this.toTestProgressEvent(event);
        if (testProgressEvent != null) {
            ((ProgressListener)this.testProgressListeners.getSource()).statusChanged(testProgressEvent);
        }
    }

    private void broadcastTaskProgressEvent(InternalProgressEvent event) {
        TaskProgressEvent taskProgressEvent = this.toTaskProgressEvent(event);
        if (taskProgressEvent != null) {
            ((ProgressListener)this.taskProgressListeners.getSource()).statusChanged(taskProgressEvent);
        }
    }

    private void broadcastProgressEvent(InternalProgressEvent event) {
        ProgressEvent progressEvent = this.toProgressEvent(event);
        if (progressEvent != null) {
            ((ProgressListener)this.buildOperationProgressListeners.getSource()).statusChanged(progressEvent);
        }
    }

    private TestProgressEvent toTestProgressEvent(InternalTestProgressEvent event) {
        if (event instanceof InternalTestStartedProgressEvent) {
            return this.testStartedEvent((InternalTestStartedProgressEvent)event);
        }
        if (event instanceof InternalTestFinishedProgressEvent) {
            return this.testFinishedEvent((InternalTestFinishedProgressEvent)event);
        }
        return null;
    }

    private TaskProgressEvent toTaskProgressEvent(InternalProgressEvent event) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.taskStartedEvent((InternalOperationStartedProgressEvent)event);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.taskFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private ProgressEvent toProgressEvent(InternalProgressEvent event) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.startedEvent((InternalOperationStartedProgressEvent)event);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.finishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private TestStartEvent testStartedEvent(InternalTestStartedProgressEvent event) {
        TestOperationDescriptor testDescriptor = this.addDescriptor(event.getDescriptor(), this.toTestDescriptor(event.getDescriptor()));
        return new DefaultTestStartEvent(event.getEventTime(), event.getDisplayName(), testDescriptor);
    }

    private TaskStartEvent taskStartedEvent(InternalOperationStartedProgressEvent event) {
        TaskOperationDescriptor descriptor = this.addDescriptor(event.getDescriptor(), this.toTaskDescriptor((InternalTaskDescriptor)event.getDescriptor()));
        return new DefaultTaskStartEvent(event.getEventTime(), event.getDisplayName(), descriptor);
    }

    private StartEvent startedEvent(InternalOperationStartedProgressEvent event) {
        OperationDescriptor descriptor = this.addDescriptor(event.getDescriptor(), this.toDescriptor(event.getDescriptor()));
        return new DefaultStartEvent(event.getEventTime(), event.getDisplayName(), descriptor);
    }

    private TestFinishEvent testFinishedEvent(InternalTestFinishedProgressEvent event) {
        TestOperationDescriptor descriptor = this.removeDescriptor(TestOperationDescriptor.class, event.getDescriptor());
        return new DefaultTestFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, this.toTestResult(event.getResult()));
    }

    private TaskFinishEvent taskFinishedEvent(InternalOperationFinishedProgressEvent event) {
        TaskOperationDescriptor descriptor = this.removeDescriptor(TaskOperationDescriptor.class, event.getDescriptor());
        return new DefaultTaskFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toTaskResult((InternalTaskResult)event.getResult()));
    }

    private FinishEvent finishedEvent(InternalOperationFinishedProgressEvent event) {
        OperationDescriptor descriptor = this.removeDescriptor(OperationDescriptor.class, event.getDescriptor());
        return new DefaultFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toResult(event.getResult()));
    }

    private synchronized <T extends OperationDescriptor> T addDescriptor(InternalOperationDescriptor descriptor, T clientDescriptor) {
        OperationDescriptor cached = this.descriptorCache.get(descriptor.getId());
        if (cached != null) {
            throw new IllegalStateException(String.format("Operation %s already available.", descriptor));
        }
        this.descriptorCache.put(descriptor.getId(), clientDescriptor);
        return clientDescriptor;
    }

    private synchronized <T extends OperationDescriptor> T removeDescriptor(Class<T> type, InternalOperationDescriptor descriptor) {
        OperationDescriptor cachedTestDescriptor = this.descriptorCache.remove(descriptor.getId());
        if (cachedTestDescriptor == null) {
            throw new IllegalStateException(String.format("Operation %s is not available.", descriptor));
        }
        return this.assertDescriptorType(type, cachedTestDescriptor);
    }

    private <T extends OperationDescriptor> T assertDescriptorType(Class<T> type, OperationDescriptor descriptor) {
        Class<?> descriptorClass = descriptor.getClass();
        if (!type.isAssignableFrom(descriptorClass)) {
            throw new IllegalStateException(String.format("Unexpected operation type. Required %s but found %s", type.getName(), descriptorClass.getName()));
        }
        return (T)descriptor;
    }

    private TestOperationDescriptor toTestDescriptor(InternalTestDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        if (descriptor instanceof InternalJvmTestDescriptor) {
            InternalJvmTestDescriptor jvmTestDescriptor = (InternalJvmTestDescriptor)descriptor;
            return new DefaultJvmTestOperationDescriptor(jvmTestDescriptor, parent, BuildProgressListenerAdapter.toJvmTestKind(jvmTestDescriptor.getTestKind()), jvmTestDescriptor.getSuiteName(), jvmTestDescriptor.getClassName(), jvmTestDescriptor.getMethodName());
        }
        return new DefaultTestOperationDescriptor(descriptor, parent);
    }

    private static JvmTestKind toJvmTestKind(String testKind) {
        if ("SUITE".equals(testKind)) {
            return JvmTestKind.SUITE;
        }
        if ("ATOMIC".equals(testKind)) {
            return JvmTestKind.ATOMIC;
        }
        return JvmTestKind.UNKNOWN;
    }

    private TaskOperationDescriptor toTaskDescriptor(InternalTaskDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultTaskOperationDescriptor(descriptor, descriptor.getTaskPath(), parent);
    }

    private OperationDescriptor toDescriptor(InternalOperationDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultOperationDescriptor(descriptor, parent);
    }

    private synchronized OperationDescriptor getParentDescriptor(Object parentId) {
        if (parentId == null) {
            return null;
        }
        OperationDescriptor operationDescriptor = this.descriptorCache.get(parentId);
        if (operationDescriptor == null) {
            throw new IllegalStateException(String.format("Parent operation with id %s not available.", parentId));
        }
        return operationDescriptor;
    }

    private TestOperationResult toTestResult(InternalTestResult result) {
        if (result instanceof InternalTestSuccessResult) {
            return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestSkippedResult) {
            return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestFailureResult) {
            return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static TaskOperationResult toTaskResult(InternalTaskResult result) {
        if (result instanceof InternalTaskSuccessResult) {
            return new DefaultTaskSuccessResult(result.getStartTime(), result.getEndTime(), ((InternalTaskSuccessResult)result).isUpToDate());
        }
        if (result instanceof InternalTaskSkippedResult) {
            return new DefaultTaskSkippedResult(result.getStartTime(), result.getEndTime(), ((InternalTaskSkippedResult)result).getSkipMessage());
        }
        if (result instanceof InternalTaskFailureResult) {
            return new DefaultTaskFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static OperationResult toResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultOperationSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultOperationFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static List<Failure> toFailures(List<? extends InternalFailure> causes) {
        if (causes == null) {
            return null;
        }
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (InternalFailure internalFailure : causes) {
            failures.add(BuildProgressListenerAdapter.toFailure(internalFailure));
        }
        return failures;
    }

    private static Failure toFailure(InternalFailure origFailure) {
        return origFailure == null ? null : new DefaultFailure(origFailure.getMessage(), origFailure.getDescription(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()));
    }
}

