/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspectionBase;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;

public class IntentionDescriptionNotFoundInspection
extends DescriptionNotFoundInspectionBase {
    public IntentionDescriptionNotFoundInspection() {
        super(DescriptionType.INTENTION);
    }

    @Override
    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, DescriptionType.INTENTION);
    }

    @Override
    @NotNull
    protected String getHasNotDescriptionError() {
        if ("Intention does not have a description" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getHasNotDescriptionError"));
        }
        return "Intention does not have a description";
    }

    @Override
    @NotNull
    protected String getHasNotBeforeAfterError() {
        if ("Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getHasNotBeforeAfterError"));
        }
        return "Intention must have 'before.*.template' and 'after.*.template' beside 'description.html'";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Intention Description Checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getDisplayName"));
        }
        return "Intention Description Checker";
    }

    @NotNull
    public String getShortName() {
        if ("IntentionDescriptionNotFoundInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/IntentionDescriptionNotFoundInspection", "getShortName"));
        }
        return "IntentionDescriptionNotFoundInspection";
    }
}

