/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractXMLHandler
implements Locator {
    private AttributesImpl mySharedAttributes;
    private ContentHandler myHandler;
    private ISVNDebugLog myLog;

    protected AbstractXMLHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        this.myHandler = contentHandler;
        this.myLog = log == null ? SVNDebugLog.getDefaultLog() : log;
    }

    protected ISVNDebugLog getDebugLog() {
        return this.myLog;
    }

    public void startDocument() {
        try {
            this.getHandler().setDocumentLocator(this);
            this.getHandler().startDocument();
            this.openTag(this.getHeaderName());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void endDocument() {
        try {
            this.closeTag(this.getHeaderName());
            this.getHandler().endDocument();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private ContentHandler getHandler() {
        return this.myHandler;
    }

    protected abstract String getHeaderName();

    protected void openTag(String name) throws SAXException {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.getHandler().startElement("", "", name, this.mySharedAttributes);
        this.mySharedAttributes.clear();
    }

    protected void closeTag(String name) throws SAXException {
        this.getHandler().endElement("", "", name);
    }

    protected void addTag(String tagName, String value) throws SAXException {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.getHandler().startElement("", "", tagName, this.mySharedAttributes);
        this.mySharedAttributes.clear();
        value = value == null ? "" : value;
        this.getHandler().characters(value.toCharArray(), 0, value.length());
        this.getHandler().endElement("", "", tagName);
    }

    protected void addAttribute(String name, String value) {
        if (this.mySharedAttributes == null) {
            this.mySharedAttributes = new AttributesImpl();
        }
        this.mySharedAttributes.addAttribute("", "", name, "CDATA", value);
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }
}

