/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.resources.DefaultTextResourceFactory;
import org.gradle.api.resources.ReadableResource;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;

public class DefaultResourceHandler
implements ResourceHandler {
    private final FileOperations fileOperations;
    private final TextResourceFactory textResourceFactory;

    public DefaultResourceHandler(FileOperations fileOperations, TemporaryFileProvider tempFileProvider) {
        this.fileOperations = fileOperations;
        this.textResourceFactory = new DefaultTextResourceFactory(fileOperations, tempFileProvider);
    }

    public ReadableResource gzip(Object path) {
        return new GzipArchiver(this.fileOperations.getFileResolver().resolveResource(path));
    }

    public ReadableResource bzip2(Object path) {
        return new Bzip2Archiver(this.fileOperations.getFileResolver().resolveResource(path));
    }

    public TextResourceFactory getText() {
        return this.textResourceFactory;
    }
}

