/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal;

import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.model.internal.manage.schema.extract.ManagedInstanceTypeUtils;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicObjectAwareTypeUtils {
    public static <T> ModelType<? super T> extractModelTypeFromType(ModelType<T> type) {
        if (DynamicObjectAware.class.isAssignableFrom(type.getRawClass())) {
            return ModelType.of(type.getRawClass().getSuperclass());
        }
        return type;
    }

    public static <T> ModelType<? super T> extractModelTypeFromInstance(T instance) {
        ModelType managedType = ManagedInstanceTypeUtils.extractModelTypeFromInstance(instance);
        return DynamicObjectAwareTypeUtils.extractModelTypeFromType(managedType);
    }
}

