/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import com.tonicsystems.jarjar.JarJarTask;
import com.tonicsystems.jarjar.Rule;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.URLResource;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.process.internal.child.BootstrapSecurityManager;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.SystemApplicationClassLoaderWorker;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.AntUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerProcessClassPathProvider
implements ClassPathProvider,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerProcessClassPathProvider.class);
    private final CacheRepository cacheRepository;
    private final ModuleRegistry moduleRegistry;
    private final Object lock = new Object();
    private ClassPath workerClassPath;
    private PersistentCache workerClassPathCache;

    public WorkerProcessClassPathProvider(CacheRepository cacheRepository, ModuleRegistry moduleRegistry) {
        this.cacheRepository = cacheRepository;
        this.moduleRegistry = moduleRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(String name) {
        if (name.equals("WORKER_PROCESS")) {
            DefaultClassPath classpath = new DefaultClassPath(new File[0]);
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-core").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-native").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-messaging").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("slf4j-api").getClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("jul-to-slf4j").getClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("guava-jdk5").getClasspath());
            return classpath;
        }
        if (name.equals("WORKER_MAIN")) {
            Object object = this.lock;
            synchronized (object) {
                if (this.workerClassPath == null) {
                    this.workerClassPathCache = this.cacheRepository.cache("workerMain").withInitializer(new CacheInitializer()).open();
                    this.workerClassPath = new DefaultClassPath(new File[]{WorkerProcessClassPathProvider.jarFile(this.workerClassPathCache)});
                }
                LOGGER.debug("Using worker process classpath: {}", (Object)this.workerClassPath);
                return this.workerClassPath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.workerClassPathCache != null) {
                    this.workerClassPathCache.close();
                }
            }
            finally {
                this.workerClassPathCache = null;
                this.workerClassPath = null;
            }
        }
    }

    private static File jarFile(PersistentCache cache) {
        return new File(cache.getBaseDir(), "gradle-worker.jar");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheInitializer
    implements Action<PersistentCache> {
        private CacheInitializer() {
        }

        public void execute(PersistentCache cache) {
            File jarFile = WorkerProcessClassPathProvider.jarFile(cache);
            LOGGER.debug("Generating worker process classes to {}.", (Object)jarFile);
            URL currentClasspath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            JarJarTask task = new JarJarTask();
            task.setDestFile(jarFile);
            final ArrayList<1> classResources = new ArrayList<1>();
            List<Class> renamedClasses = Arrays.asList(GradleWorkerMain.class, BootstrapSecurityManager.class, EncodedStream.EncodedInput.class);
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.addAll(renamedClasses);
            for (Class aClass : classes) {
                Enumeration<URL> resources;
                final String fileName = aClass.getName().replace('.', '/') + ".class";
                try {
                    resources = WorkerProcessClassPathProvider.class.getClassLoader().getResources(fileName);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
                URL resource = null;
                while (resources.hasMoreElements()) {
                    URL url;
                    resource = url = resources.nextElement();
                    if (!url.toString().startsWith(currentClasspath.toString())) continue;
                    break;
                }
                URLResource urlResource = new URLResource(resource){

                    public synchronized String getName() {
                        return fileName;
                    }
                };
                classResources.add(urlResource);
            }
            task.add(new ResourceCollection(){

                public Iterator iterator() {
                    return classResources.iterator();
                }

                public int size() {
                    return classResources.size();
                }

                public boolean isFilesystemOnly() {
                    return true;
                }
            });
            Rule rule = new Rule();
            rule.setPattern(SystemApplicationClassLoaderWorker.class.getName());
            rule.setResult(SystemApplicationClassLoaderWorker.class.getName());
            task.addConfiguredRule(rule);
            rule = new Rule();
            rule.setPattern("org.gradle.**");
            rule.setResult("jarjar.@0");
            task.addConfiguredRule(rule);
            AntUtil.execute((Task)task);
        }
    }
}

