/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.math.BigDecimal;

public class DurationFormatter {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;

    public String format(long duration) {
        if (duration == 0L) {
            return "0s";
        }
        StringBuilder result = new StringBuilder();
        long days = duration / 86400000L;
        duration %= 86400000L;
        if (days > 0L) {
            result.append(days);
            result.append("d");
        }
        long hours = duration / 3600000L;
        duration %= 3600000L;
        if (hours > 0L || result.length() > 0) {
            result.append(hours);
            result.append("h");
        }
        long minutes = duration / 60000L;
        duration %= 60000L;
        if (minutes > 0L || result.length() > 0) {
            result.append(minutes);
            result.append("m");
        }
        int secondsScale = result.length() > 0 ? 2 : 3;
        result.append(BigDecimal.valueOf(duration).divide(BigDecimal.valueOf(1000L)).setScale(secondsScale, 4));
        result.append("s");
        return result.toString();
    }
}

