/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class AliasedAnnotationHolder
implements AnnotationHolder {
    private final AnnotationHolder myHolder;
    private final GrAnnotation myAlias;
    private final GrCodeReferenceElement myReference;

    public AliasedAnnotationHolder(@NotNull AnnotationHolder holder, @NotNull GrAnnotation alias) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "<init>"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "<init>"));
        }
        this.myHolder = holder;
        this.myAlias = alias;
        this.myReference = this.myAlias.getClassReference();
    }

    @NotNull
    private PsiElement findCodeElement(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "findCodeElement"));
        }
        if (PsiTreeUtil.isAncestor((PsiElement)this.myAlias, (PsiElement)elt, (boolean)true)) {
            PsiElement psiElement = elt;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "findCodeElement"));
            }
            return psiElement;
        }
        GrCodeReferenceElement grCodeReferenceElement = this.myReference;
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "findCodeElement"));
        }
        return grCodeReferenceElement;
    }

    public Annotation createErrorAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createErrorAnnotation"));
        }
        PsiElement codeElement = this.findCodeElement(elt);
        return this.myHolder.createErrorAnnotation(codeElement, message);
    }

    public Annotation createErrorAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createErrorAnnotation"));
        }
        return this.createErrorAnnotation(node.getPsi(), message);
    }

    public Annotation createErrorAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createErrorAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWarningAnnotation"));
        }
        return this.myHolder.createWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWarningAnnotation"));
        }
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWarningAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWeakWarningAnnotation"));
        }
        return this.myHolder.createWeakWarningAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWeakWarningAnnotation"));
        }
        return this.myHolder.createWarningAnnotation(node.getPsi(), message);
    }

    public Annotation createWeakWarningAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createWeakWarningAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createInfoAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createInfoAnnotation"));
        }
        return this.myHolder.createInfoAnnotation(this.findCodeElement(elt), message);
    }

    public Annotation createInfoAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createInfoAnnotation"));
        }
        return this.myHolder.createInfoAnnotation(node.getPsi(), message);
    }

    public Annotation createInfoAnnotation(@NotNull TextRange range, @Nullable String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createInfoAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String htmlTooltip) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "createAnnotation"));
        }
        throw new UnsupportedOperationException("unsupported");
    }

    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        AnnotationSession annotationSession = this.myHolder.getCurrentAnnotationSession();
        if (annotationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/checkers/AliasedAnnotationHolder", "getCurrentAnnotationSession"));
        }
        return annotationSession;
    }

    public boolean isBatchMode() {
        return this.myHolder.isBatchMode();
    }
}

