/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CreateSetterFromUsageFix
extends CreateMethodFromUsageFix
implements LowPriorityAction {
    public CreateSetterFromUsageFix(@NotNull GrReferenceExpression refExpression) {
        if (refExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpression", "org/jetbrains/plugins/groovy/annotator/intentions/CreateSetterFromUsageFix", "<init>"));
        }
        super(refExpression);
    }

    @Override
    @NotNull
    protected TypeConstraint[] getReturnTypeConstraints() {
        TypeConstraint[] typeConstraintArray = new TypeConstraint[]{SubtypeConstraint.create((PsiType)PsiType.VOID)};
        if (typeConstraintArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateSetterFromUsageFix", "getReturnTypeConstraints"));
        }
        return typeConstraintArray;
    }

    @Override
    protected PsiType[] getArgumentTypes() {
        GrReferenceExpression ref = this.getRefExpr();
        assert (PsiUtil.isLValue(ref));
        PsiType initializer = TypeInferenceHelper.getInitializerTypeFor(ref);
        if (initializer == null || initializer == PsiType.NULL) {
            initializer = TypesUtil.getJavaLangObject(ref);
        }
        return new PsiType[]{initializer};
    }

    @Override
    @NotNull
    protected String getMethodName() {
        String string = GroovyPropertyUtils.getSetterName(this.getRefExpr().getReferenceName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateSetterFromUsageFix", "getMethodName"));
        }
        return string;
    }
}

