/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.shell.GroovyShellRunnerImpl;

public class GroovyCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS && psiFile.getUserData(GroovyShellRunnerImpl.GROOVY_SHELL_FILE) == Boolean.TRUE) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (PsiImplUtil.isLeafElementOfType((PsiElement)contextElement, (TokenSet)TokenSets.STRING_LITERALS)) {
            PsiElement parent = contextElement.getParent();
            if (parent != null) {
                for (PsiReference reference : parent.getReferences()) {
                    if (reference.isSoft() || !reference.getRangeInElement().shiftRight(parent.getTextOffset()).containsOffset(offset)) continue;
                    ThreeState threeState = ThreeState.NO;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
                    }
                    return threeState;
                }
            }
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"def"})).accepts((Object)contextElement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        if (contextElement.textMatches((CharSequence)"..") || contextElement.textMatches((CharSequence)"...")) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionConfidence", "shouldSkipAutopopup"));
        }
        return threeState;
    }
}

