/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ClassType;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrReferenceListElementType;

public class ReferenceElement {
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz";

    @NotNull
    public static IElementType parseReferenceList(@NotNull PsiBuilder builder, @NotNull IElementType startElement, @NotNull GrReferenceListElementType<?> clauseType, @NotNull ClassType type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (clauseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clauseType", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        PsiBuilder.Marker isMarker = builder.mark();
        if (!ParserUtils.getToken(builder, startElement)) {
            if (clauseType == GroovyElementTypes.IMPLEMENTS_CLAUSE && (type == ClassType.INTERFACE || type == ClassType.ANNOTATION) || clauseType == GroovyElementTypes.EXTENDS_CLAUSE && type == ClassType.ENUM || type == ClassType.ANNOTATION) {
                isMarker.rollbackTo();
                GroovyElementType groovyElementType = GroovyElementTypes.NONE;
                if (groovyElementType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
                }
                return groovyElementType;
            }
            GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(builder, clauseType, isMarker, null, null);
            if (grReferenceListElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
            }
            return grReferenceListElementType;
        }
        PsiBuilder.Marker space = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (ReferenceElement.parseReferenceElement(builder) == ReferenceElementResult.FAIL) {
            GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(builder, clauseType, isMarker, space, GroovyBundle.message("identifier.expected", new Object[0]));
            if (grReferenceListElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
            }
            return grReferenceListElementType;
        }
        space.drop();
        while (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
            space = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (ReferenceElement.parseReferenceElement(builder) == ReferenceElementResult.FAIL) {
                GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(builder, clauseType, isMarker, space, GroovyBundle.message("identifier.expected", new Object[0]));
                if (grReferenceListElementType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
                }
                return grReferenceListElementType;
            }
            space.drop();
        }
        GrReferenceListElementType<?> grReferenceListElementType = ReferenceElement.finish(builder, clauseType, isMarker, null, null);
        if (grReferenceListElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceList"));
        }
        return grReferenceListElementType;
    }

    @NotNull
    private static GrReferenceListElementType<?> finish(@NotNull PsiBuilder builder, @NotNull GrReferenceListElementType<?> clauseType, @NotNull PsiBuilder.Marker isMarker, @Nullable PsiBuilder.Marker space, @Nullable String error) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        if (clauseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clauseType", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        if (isMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isMarker", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        if (space != null) {
            space.rollbackTo();
        }
        if (error != null) {
            builder.error(error);
        }
        isMarker.done(clauseType);
        GrReferenceListElementType<?> grReferenceListElementType = clauseType;
        if (grReferenceListElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "finish"));
        }
        return grReferenceListElementType;
    }

    public static ReferenceElementResult parseForImport(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseForImport"));
        }
        return ReferenceElement.parse(builder, false, false, true, false, false);
    }

    public static ReferenceElementResult parseForPackage(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseForPackage"));
        }
        return ReferenceElement.parse(builder, false, false, true, false, false);
    }

    public static ReferenceElementResult parseReferenceElement(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceElement"));
        }
        return ReferenceElement.parseReferenceElement(builder, false, true);
    }

    public static ReferenceElementResult parseReferenceElement(@NotNull PsiBuilder builder, boolean isUpperCase, boolean expressionPossible) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parseReferenceElement"));
        }
        return ReferenceElement.parse(builder, isUpperCase, true, false, false, expressionPossible);
    }

    public static ReferenceElementResult parse(@NotNull PsiBuilder builder, boolean checkUpperCase, boolean parseTypeArgs, boolean lineFeedAllowed, boolean allowDiamond, boolean expressionPossible) {
        boolean hasDots;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/typeDefinitions/ReferenceElement", "parse"));
        }
        PsiBuilder.Marker internalTypeMarker = builder.mark();
        String lastIdentifier = builder.getTokenText();
        if (!ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS)) {
            internalTypeMarker.rollbackTo();
            return ReferenceElementResult.FAIL;
        }
        boolean hasTypeArguments = false;
        if (parseTypeArgs && TypeArguments.parseTypeArguments(builder, expressionPossible, allowDiamond)) {
            hasTypeArguments = true;
        }
        internalTypeMarker.done((IElementType)GroovyElementTypes.REFERENCE_ELEMENT);
        internalTypeMarker = internalTypeMarker.precede();
        boolean bl = hasDots = builder.getTokenType() == GroovyTokenTypes.mDOT;
        while (builder.getTokenType() == GroovyTokenTypes.mDOT) {
            if ((ParserUtils.lookAhead(builder, GroovyTokenTypes.mDOT, GroovyTokenTypes.mSTAR) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mDOT, GroovyTokenTypes.mNLS, GroovyTokenTypes.mSTAR)) && lineFeedAllowed) {
                internalTypeMarker.drop();
                return ReferenceElementResult.PATH_REF;
            }
            ParserUtils.getToken(builder, GroovyTokenTypes.mDOT);
            if (lineFeedAllowed) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            }
            lastIdentifier = builder.getTokenText();
            if (!ParserUtils.getToken(builder, TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS)) {
                if (TokenSets.REFERENCE_NAME_PREFIXES.contains(builder.getTokenType())) {
                    internalTypeMarker.rollbackTo();
                    return ReferenceElementResult.FAIL;
                }
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                internalTypeMarker.done((IElementType)GroovyElementTypes.REFERENCE_ELEMENT);
                return ReferenceElementResult.PATH_REF;
            }
            if (parseTypeArgs && TypeArguments.parseTypeArguments(builder, expressionPossible, allowDiamond)) {
                hasTypeArguments = true;
            }
            internalTypeMarker.done((IElementType)GroovyElementTypes.REFERENCE_ELEMENT);
            internalTypeMarker = internalTypeMarker.precede();
        }
        if (lastIdentifier == null) {
            return ReferenceElementResult.FAIL;
        }
        char firstChar = lastIdentifier.charAt(0);
        if (checkUpperCase && (!Character.isUpperCase(firstChar) || DUMMY_IDENTIFIER.equals(lastIdentifier))) {
            internalTypeMarker.rollbackTo();
            return ReferenceElementResult.FAIL;
        }
        internalTypeMarker.drop();
        return hasTypeArguments ? ReferenceElementResult.REF_WITH_TYPE_PARAMS : (hasDots ? ReferenceElementResult.PATH_REF : ReferenceElementResult.IDENTIFIER);
    }

    public static enum ReferenceElementResult {
        IDENTIFIER,
        PATH_REF,
        REF_WITH_TYPE_PARAMS,
        FAIL;

    }
}

