/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrMethodSignatureImpl
implements GrClosureSignature {
    private final PsiMethod myMethod;
    private final PsiSubstitutor mySubstitutor;

    public GrMethodSignatureImpl(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "<init>"));
        }
        this.myMethod = method;
        this.mySubstitutor = substitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        Object[] parameters = this.myMethod.getParameterList().getParameters();
        GrClosureParameter[] grClosureParameterArray = (GrClosureParameter[])ContainerUtil.map((Object[])parameters, (Function)new Function<PsiParameter, GrClosureParameter>(){

            public GrClosureParameter fun(PsiParameter parameter) {
                return GrMethodSignatureImpl.this.createClosureParameter(parameter);
            }
        }, (Object[])new GrClosureParameter[parameters.length]);
        if (grClosureParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "getParameters"));
        }
        return grClosureParameterArray;
    }

    @NotNull
    protected GrClosureParameter createClosureParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "createClosureParameter"));
        }
        GrClosureParameterImpl grClosureParameterImpl = new GrClosureParameterImpl(parameter, this.getSubstitutor());
        if (grClosureParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "createClosureParameter"));
        }
        return grClosureParameterImpl;
    }

    @Override
    public int getParameterCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Override
    public boolean isVarargs() {
        return GrClosureSignatureUtil.isVarArgsImpl(this.getParameters());
    }

    @Override
    public PsiType getReturnType() {
        return this.getSubstitutor().substitute(PsiUtil.getSmartReturnType(this.myMethod));
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myMethod.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    @Nullable
    public GrSignature curry(@NotNull PsiType[] args, int position, @NotNull PsiElement context) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "curry"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "curry"));
        }
        return GrClosureSignatureUtil.curryImpl(this, args, position, context);
    }

    @Override
    public void accept(@NotNull GrSignatureVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrMethodSignatureImpl", "accept"));
        }
        visitor.visitClosureSignature(this);
    }
}

