/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.clauses;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrForInClauseImpl
extends GroovyPsiElementImpl
implements GrForInClause,
GrParametersOwner {
    public GrForInClauseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrForInClauseImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitForInClause(this);
    }

    public String toString() {
        return "In clause";
    }

    @Override
    public GrParameter getDeclaredVariable() {
        return (GrParameter)this.findChildByClass(GrParameter.class);
    }

    @Override
    public GrParameter[] getParameters() {
        GrParameter[] grParameterArray;
        GrParameter declaredVariable = this.getDeclaredVariable();
        if (declaredVariable == null) {
            grParameterArray = GrParameter.EMPTY_ARRAY;
        } else {
            GrParameter[] grParameterArray2 = new GrParameter[1];
            grParameterArray = grParameterArray2;
            grParameterArray2[0] = declaredVariable;
        }
        return grParameterArray;
    }

    @Override
    public GrParameterList getParameterList() {
        return null;
    }

    @Override
    public boolean isVarArgs() {
        throw new IncorrectOperationException("For in clause cannot have varargs");
    }

    @Override
    @Nullable
    public GrExpression getIteratedExpression() {
        return GrForInClauseImpl.findExpressionChild(this);
    }

    @Override
    @NotNull
    public PsiElement getDelimiter() {
        PsiElement in = this.findChildByType(GroovyTokenTypes.kIN);
        if (in != null) {
            PsiElement psiElement = in;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrForInClauseImpl", "getDelimiter"));
            }
            return psiElement;
        }
        PsiElement colon = this.findChildByType(GroovyTokenTypes.mCOLON);
        PsiElement psiElement = (PsiElement)ObjectUtils.assertNotNull((Object)colon);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/clauses/GrForInClauseImpl", "getDelimiter"));
        }
        return psiElement;
    }
}

