/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    public static Map<String, List<CandidateInfo>> getAllMethods(PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getMethods();
    }

    @NotNull
    private static ClassMembers getCachedMembers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getCachedMembers"));
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        Key<CachedValue<ClassMembers>> key = includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
        CachedValue<ClassMembers> cachedValue = (CachedValue<ClassMembers>)aClass.getUserData(key);
        if (CollectClassMembersUtil.isCyclicDependence(aClass)) {
            includeSynthetic = false;
        }
        if (cachedValue == null) {
            cachedValue = CollectClassMembersUtil.buildCache(aClass, includeSynthetic);
            aClass.putUserData(key, cachedValue);
        }
        ClassMembers classMembers = (ClassMembers)cachedValue.getValue();
        if (classMembers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getCachedMembers"));
        }
        return classMembers;
    }

    private static boolean isCyclicDependence(PsiClass aClass) {
        return !CollectClassMembersUtil.processCyclicDependence(aClass, ContainerUtil.newHashSet());
    }

    private static boolean processCyclicDependence(PsiClass aClass, Set<PsiClass> classes) {
        if (!classes.add(aClass)) {
            return aClass.isInterface() || "java.lang.Object".equals(aClass.getQualifiedName());
        }
        if (aClass instanceof ClsClassImpl) {
            return true;
        }
        for (PsiClass psiClass : aClass.getSupers()) {
            if (CollectClassMembersUtil.processCyclicDependence(psiClass, classes)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, CandidateInfo> getAllInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getAllInnerClasses"));
        }
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getInnerClasses();
    }

    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getAllFields"));
        }
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getFields();
    }

    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getAllFields"));
        }
        return CollectClassMembersUtil.getAllFields(aClass, true);
    }

    private static CachedValue<ClassMembers> buildCache(final @NotNull PsiClass aClass, final boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "buildCache"));
        }
        return CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<ClassMembers>(){

            public CachedValueProvider.Result<ClassMembers> compute() {
                LinkedHashMap allFields = ContainerUtil.newLinkedHashMap();
                LinkedHashMap allMethods = ContainerUtil.newLinkedHashMap();
                LinkedHashMap allInnerClasses = ContainerUtil.newLinkedHashMap();
                CollectClassMembersUtil.processClass(aClass, allFields, allMethods, allInnerClasses, (Set)new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
                return CachedValueProvider.Result.create((Object)ClassMembers.create(allFields, allMethods, allInnerClasses), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    private static void processClass(@NotNull PsiClass aClass, @NotNull Map<String, CandidateInfo> allFields, @NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull Map<String, CandidateInfo> allInnerClasses, @NotNull Set<PsiClass> visitedClasses, @NotNull PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        if (allFields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFields", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        if (allMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMethods", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        if (allInnerClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allInnerClasses", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        if (visitedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedClasses", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "processClass"));
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        if (!visitedClasses.add(aClass)) {
            return;
        }
        if (visitedClasses.size() == 1 || !GrTraitUtil.isTrait(aClass)) {
            for (PsiField psiField : CollectClassMembersUtil.getFields(aClass, includeSynthetic)) {
                GrModifierList modifierList;
                CandidateInfo candidateInfo;
                PsiElement element;
                name = psiField.getName();
                if (!allFields.containsKey(name)) {
                    allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
                    continue;
                }
                if (!CollectClassMembersUtil.hasExplicitVisibilityModifiers(psiField) || !((element = (candidateInfo = allFields.get(name)).getElement()) instanceof GrField) || (modifierList = ((GrField)element).getModifierList()) != null && modifierList.hasExplicitVisibilityModifiers() || aClass != ((GrField)element).getContainingClass()) continue;
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
            }
        }
        for (PsiField psiField : CollectClassMembersUtil.getMethods(aClass, includeSynthetic)) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : aClass.getInnerClasses()) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : aClass.getSuperTypes()) {
            PsiClass superClass = psiField.resolve();
            if (superClass == null) continue;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)substitutor);
            CollectClassMembersUtil.processClass(superClass, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    public static PsiField[] getFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getFields"));
        }
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getFields() : ((GrTypeDefinition)aClass).getCodeFields();
    }

    public static PsiMethod[] getMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "getMethods"));
        }
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getCodeMethods();
    }

    private static boolean hasExplicitVisibilityModifiers(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "hasExplicitVisibilityModifiers"));
        }
        if (field instanceof GrField) {
            GrModifierList list = (GrModifierList)field.getModifierList();
            return list == null || list.hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(@NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        if (allMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allMethods", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "addMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "addMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil", "addMethod"));
        }
        String name = method.getName();
        List<CandidateInfo> methods = allMethods.get(name);
        if (methods == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
        }
        methods.add(new CandidateInfo((PsiElement)method, substitutor));
    }

    private static class ClassMembers {
        private final Map<String, CandidateInfo> myFields;
        private final Map<String, List<CandidateInfo>> myMethods;
        private final Map<String, CandidateInfo> myInnerClasses;

        private ClassMembers(@NotNull Map<String, CandidateInfo> fields, @NotNull Map<String, List<CandidateInfo>> methods, @NotNull Map<String, CandidateInfo> innerClasses) {
            if (fields == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "<init>"));
            }
            if (methods == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "<init>"));
            }
            if (innerClasses == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "<init>"));
            }
            this.myFields = fields;
            this.myMethods = methods;
            this.myInnerClasses = innerClasses;
        }

        public static ClassMembers create(@NotNull LinkedHashMap<String, CandidateInfo> first, @NotNull LinkedHashMap<String, List<CandidateInfo>> second, @NotNull LinkedHashMap<String, CandidateInfo> third) {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "create"));
            }
            if (second == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "create"));
            }
            if (third == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "third", "org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil$ClassMembers", "create"));
            }
            return new ClassMembers(first, second, third);
        }

        private Map<String, CandidateInfo> getFields() {
            return this.myFields;
        }

        private Map<String, List<CandidateInfo>> getMethods() {
            return this.myMethods;
        }

        private Map<String, CandidateInfo> getInnerClasses() {
            return this.myInnerClasses;
        }
    }
}

