/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.context.ContextType;
import org.intellij.lang.xpath.context.functions.Function;
import org.jetbrains.annotations.NotNull;

public abstract class XPathFunctionProvider {
    public static final ExtensionPointName<XPathFunctionProvider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"XPathView.xpath.functionProvider");

    @NotNull
    public abstract Map<QName, ? extends Function> getFunctions(ContextType var1);

    public static List<Pair<QName, ? extends Function>> getAvailableFunctions(ContextType type) {
        XPathFunctionProvider[] components = (XPathFunctionProvider[])Extensions.getExtensions(EXTENSION_POINT_NAME);
        ArrayList<Pair<QName, ? extends Function>> list = new ArrayList<Pair<QName, ? extends Function>>();
        for (XPathFunctionProvider provider : components) {
            Map<QName, ? extends Function> functions = provider.getFunctions(type);
            Set<QName> names = functions.keySet();
            for (QName name : names) {
                list.add((Pair<QName, ? extends Function>)Pair.create((Object)name, (Object)functions.get(name)));
            }
        }
        return list;
    }
}

