/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.intellij.plugins.xpathView.ui.Expression;

public class ExpressionCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private final Project project;

    public ExpressionCellRenderer(Project project) {
        this.project = project;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jtable, Object obj, boolean flag, boolean flag1, int i, int j) {
        super.getTableCellRendererComponent(jtable, "", flag, flag1, i, j);
        Expression expression = (Expression)obj;
        if (expression != null && expression.getExpression().length() != 0) {
            Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument(expression.getFile());
            return new MyEditorTextField(document, this.project, (FileType)expression.getFileType());
        }
        return this;
    }

    private class MyEditorTextField
    extends EditorTextField {
        public MyEditorTextField(Document document, Project project, FileType fileType) {
            super(document, project, fileType, false);
        }

        protected boolean shouldHaveBorder() {
            return false;
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setBackgroundColor(ExpressionCellRenderer.this.getBackground());
            return editor;
        }
    }
}

