/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.api.Interface;
import javajs.util.P3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.RocketRenderer;
import org.jmol.renderbio.StrandsRenderer;
import org.jmol.shapebio.BioShape;

public class RocketsRenderer
extends StrandsRenderer {
    boolean isRockets;
    protected boolean helixRockets = true;
    protected boolean renderArrowHeads;
    protected P3[] cordMidPoints;
    private RocketRenderer rr;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        if (!this.setupRR(bioShape, true)) {
            return;
        }
        this.calcRopeMidPoints();
        this.renderRockets();
        this.vwr.freeTempPoints(this.cordMidPoints);
    }

    protected void renderRockets() {
        if (this.rr == null) {
            this.rr = ((RocketRenderer)Interface.getInterface("org.jmol.renderbio.RocketRenderer")).set(this);
        }
        this.rr.renderRockets();
    }

    protected boolean setupRR(BioShape bioShape, boolean bl) {
        this.isRockets = bl;
        if (this.wireframeOnly) {
            this.renderStrands();
        } else if (!(this.wingVectors == null || this.isCarbohydrate || bl && this.isNucleic)) {
            boolean bl2;
            boolean bl3 = bl2 = !this.vwr.getBoolean(603979900);
            if (!this.isNucleic && this.renderArrowHeads != bl2) {
                bioShape.falsifyMesh();
                this.renderArrowHeads = bl2;
            }
            return true;
        }
        return false;
    }

    protected void calcRopeMidPoints() {
        int n = this.monomerCount + 1;
        this.cordMidPoints = this.vwr.allocTempPoints(n);
        ProteinStructure proteinStructure = null;
        int n2 = -10;
        P3 p3 = new P3();
        P3 p32 = new P3();
        for (int i = 0; i <= this.monomerCount; ++i) {
            P3 p33 = this.cordMidPoints[i];
            if (i < this.monomerCount && (this.helixRockets && this.structureTypes[i] == STR.HELIX || this.isRockets && this.structureTypes[i] == STR.SHEET)) {
                ProteinStructure proteinStructure2 = (ProteinStructure)this.monomers[i].getStructure();
                if (proteinStructure2 == proteinStructure) {
                    p3.add(p32);
                    n2 = i;
                } else {
                    proteinStructure = proteinStructure2;
                    p3.setT(proteinStructure2.getAxisStartPoint());
                    p32.sub2(proteinStructure2.getAxisEndPoint(), p3);
                    p32.scale(1.0f / (float)(proteinStructure2.nRes - 1));
                    if (n2 == i - 3) {
                        this.cordMidPoints[i - 1].ave(this.cordMidPoints[i - 2], p3);
                    }
                }
                p33.setT(p3);
                continue;
            }
            if (n2 == i - 1 && i > 1) {
                this.cordMidPoints[i - 1].setT(this.cordMidPoints[i > 2 ? i - 3 : i - 2]);
            }
            p33.setT(proteinStructure == null ? this.controlPoints[i] : proteinStructure.getAxisEndPoint());
            proteinStructure = null;
        }
        this.controlPoints = this.cordMidPoints;
        this.calcScreenControlPoints();
    }
}

