/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.java.BS;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class MepCalculation
extends QuantumCalculation {
    protected static final int ONE_OVER_D = 0;
    protected static final int E_MINUS_D_OVER_2 = 1;
    protected static final int ONE_OVER_ONE_PLUS_D = 2;
    protected static final int E_MINUS_D = 3;
    protected int distanceMode = 0;
    private float[] potentials;
    private P3[] atomCoordAngstroms;
    private BS bsSelected;
    private Viewer vwr;
    protected Map<String, Object> htAtomicPotentials;
    protected String resourceName;

    public MepCalculation() {
        this.rangeBohrOrAngstroms = 8.0f;
        this.distanceMode = 0;
        this.unitFactor = 1.0f;
    }

    public void set(Viewer viewer) {
        this.vwr = viewer;
    }

    public void assignPotentials(Atom[] atomArray, float[] fArray, BS bS, BS bS2, BS bS3, String string) {
        this.getAtomicPotentials(string, null);
        for (int i = 0; i < atomArray.length; ++i) {
            float f;
            if (bS3 != null && bS3.get(i)) {
                f = Float.NaN;
            } else {
                f = this.getTabulatedPotential(atomArray[i]);
                if (Float.isNaN(f)) {
                    f = 0.0f;
                }
            }
            if (Logger.debugging) {
                Logger.debug(atomArray[i].getInfo() + " " + f);
            }
            fArray[i] = f;
        }
    }

    public void setup(int n, float[] fArray, P3[] p3Array, BS bS) {
        if (n >= 0) {
            this.distanceMode = n;
        }
        this.potentials = fArray;
        this.atomCoordAngstroms = p3Array;
        this.bsSelected = bS;
    }

    public void calculate(VolumeData volumeData, BS bS, P3[] p3Array, Atom[] atomArray, float[] fArray, int n) {
        this.setup(n, fArray, atomArray, bS);
        this.voxelData = volumeData.getVoxelData();
        this.countsXYZ = volumeData.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], null);
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bS, p3Array, atomArray, null, false);
        this.setXYZBohr(this.points);
        this.process();
    }

    public float getValueAtPoint(P3 p3) {
        float f = 0.0f;
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            float f2 = this.potentials[n];
            float f3 = p3.distanceSquared(this.atomCoordAngstroms[n]);
            f += this.valueFor(f2, f3, this.distanceMode);
            n = this.bsSelected.nextSetBit(n + 1);
        }
        return f;
    }

    @Override
    protected void process() {
        int n = this.qmAtoms.length;
        while (--n >= 0) {
            this.thisAtom = this.qmAtoms[n];
            if (this.thisAtom == null) continue;
            float f = this.potentials[n];
            if (Logger.debugging) {
                Logger.debug("process map for atom " + n + this.thisAtom + "  charge=" + f);
            }
            this.thisAtom.setXYZ(this, true);
            int n2 = this.xMax;
            while (--n2 >= this.xMin) {
                float f2 = this.X2[n2];
                int n3 = this.yMax;
                while (--n3 >= this.yMin) {
                    float f3 = f2 + this.Y2[n3];
                    int n4 = this.zMax;
                    while (--n4 >= this.zMin) {
                        float[] fArray = this.voxelData[n2][n3];
                        int n5 = n4;
                        fArray[n5] = fArray[n5] + this.valueFor(f, f3 + this.Z2[n4], this.distanceMode);
                    }
                }
            }
        }
    }

    public float valueFor(float f, float f2, int n) {
        switch (n) {
            case 0: {
                return f2 == 0.0f ? f * Float.POSITIVE_INFINITY : f / (float)Math.sqrt(f2);
            }
            case 2: {
                return f / (1.0f + (float)Math.sqrt(f2));
            }
            case 1: {
                return f * (float)Math.exp(-Math.sqrt(f2) / 2.0);
            }
            case 3: {
                return f * (float)Math.exp(-Math.sqrt(f2));
            }
        }
        return f;
    }

    protected float getTabulatedPotential(Atom atom) {
        String string;
        Object object;
        String string2 = atom.getAtomType();
        String string3 = atom.getGroup1('\u0000');
        String string4 = atom.getBioStructureTypeName();
        if (string3.length() == 0 && (string3 = atom.getGroup3(true)) == null) {
            string3 = "";
        }
        if ((object = this.htAtomicPotentials.get(string = string3 + string2)) == null && string4.length() > 0) {
            object = this.htAtomicPotentials.get("_" + string4.charAt(0) + string2);
        }
        return object instanceof Float ? ((Float)object).floatValue() : Float.NaN;
    }

    protected void getAtomicPotentials(String string, String string2) {
        BufferedReader bufferedReader = null;
        this.htAtomicPotentials = new Hashtable<String, Object>();
        try {
            String string3;
            BufferedReader bufferedReader2 = bufferedReader = string == null ? FileManager.getBufferedReaderForResource(this.vwr, this, "org/jmol/quantum/", string2) : Rdr.getBR(string);
            while ((string3 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string3.startsWith("#") || (stringArray = PT.getTokens(string3)).length < 2) continue;
                if (Logger.debugging) {
                    Logger.debug(string3);
                }
                this.htAtomicPotentials.put(stringArray[0], Float.valueOf(PT.parseFloat(stringArray[1])));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception.toString() + " in getResource " + string2);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void createCube() {
    }
}

