/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.LanguageInfo;

public abstract class LabelCompositionStrategy {
    public abstract String compose(OsmPrimitive var1);

    public static class DeriveLabelFromNameTagsCompositionStrategy
    extends LabelCompositionStrategy
    implements Preferences.PreferenceChangedListener {
        private static final String[] DEFAULT_NAME_TAGS = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "distance", "ref", "operator", "brand", "addr:housenumber"};
        private static final String[] DEFAULT_NAME_COMPLEMENT_TAGS = new String[]{"capacity"};
        private List<String> nameTags = new ArrayList<String>();
        private List<String> nameComplementTags = new ArrayList<String>();

        public DeriveLabelFromNameTagsCompositionStrategy() {
            this.initNameTagsFromPreferences();
        }

        private static List<String> buildNameTags(List<String> list) {
            if (list == null) {
                list = Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (string == null || (string = string.trim()).isEmpty()) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public void setNameTags(List<String> list) {
            this.nameTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(list);
        }

        public void setNameComplementTags(List<String> list) {
            this.nameComplementTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(list);
        }

        public List<String> getNameTags() {
            return Collections.unmodifiableList(this.nameTags);
        }

        public List<String> getNameComplementTags() {
            return Collections.unmodifiableList(this.nameComplementTags);
        }

        public final void initNameTagsFromPreferences() {
            if (Main.pref == null) {
                this.nameTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_TAGS));
                this.nameComplementTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS));
            } else {
                this.nameTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(DEFAULT_NAME_TAGS)));
                this.nameComplementTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameComplementOrder", Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS)));
            }
        }

        private String getPrimitiveName(OsmPrimitive osmPrimitive) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            if (!osmPrimitive.hasKeys()) {
                return null;
            }
            for (String string2 : this.nameTags) {
                string = osmPrimitive.get(string2);
                if (string == null) continue;
                stringBuilder.append(string);
                break;
            }
            for (String string2 : this.nameComplementTags) {
                string = osmPrimitive.get(string2);
                if (string == null) continue;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(string);
                    break;
                }
                stringBuilder.append(" (").append(string).append(')');
                break;
            }
            return stringBuilder.toString();
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (osmPrimitive == null) {
                return null;
            }
            return this.getPrimitiveName(osmPrimitive);
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + '}';
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey() != null && preferenceChangeEvent.getKey().startsWith("mappaint.name")) {
                this.initNameTagsFromPreferences();
            }
        }
    }

    public static class TagLookupCompositionStrategy
    extends LabelCompositionStrategy {
        private final String defaultLabelTag;

        public TagLookupCompositionStrategy(String string) {
            if (string != null && (string = string.trim()).isEmpty()) {
                string = null;
            }
            this.defaultLabelTag = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (this.defaultLabelTag == null) {
                return null;
            }
            if (osmPrimitive == null) {
                return null;
            }
            return osmPrimitive.get(this.defaultLabelTag);
        }

        public String getDefaultLabelTag() {
            return this.defaultLabelTag;
        }

        public String toString() {
            return '{' + this.getClass().getSimpleName() + " defaultLabelTag=" + this.defaultLabelTag + '}';
        }

        public int hashCode() {
            return Objects.hash(this.defaultLabelTag);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TagLookupCompositionStrategy tagLookupCompositionStrategy = (TagLookupCompositionStrategy)object;
            return Objects.equals(this.defaultLabelTag, tagLookupCompositionStrategy.defaultLabelTag);
        }
    }

    public static class StaticLabelCompositionStrategy
    extends LabelCompositionStrategy {
        private final String defaultLabel;

        public StaticLabelCompositionStrategy(String string) {
            this.defaultLabel = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            return this.defaultLabel;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String toString() {
            return '{' + this.getClass().getSimpleName() + " defaultLabel=" + this.defaultLabel + '}';
        }

        public int hashCode() {
            return Objects.hash(this.defaultLabel);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StaticLabelCompositionStrategy staticLabelCompositionStrategy = (StaticLabelCompositionStrategy)object;
            return Objects.equals(this.defaultLabel, staticLabelCompositionStrategy.defaultLabel);
        }
    }
}

