/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.io;

import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public enum FileType {
    ALL{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.*)", new String[]{"*.*", "*"});
        }
    }
    ,
    CSV{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.csv)", new String[]{"*.csv"});
        }
    }
    ,
    PDF{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.pdf)", new String[]{"*.pdf"});
        }
    }
    ,
    TXT{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.txt)", new String[]{"*.txt"});
        }
    }
    ,
    LOG{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.log, *.txt)", new String[]{"*.log", "*.txt"});
        }
    }
    ,
    XML{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.xml)", new String[]{"*.xml"});
        }
    }
    ,
    JSON{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.json)", new String[]{"*.json"});
        }
    }
    ,
    HTML{

        @Override
        public FileChooser.ExtensionFilter getFilter() {
            return new FileChooser.ExtensionFilter("(*.html, *.htm)", new String[]{"*.htm", "*.html"});
        }
    };


    public abstract FileChooser.ExtensionFilter getFilter();

    public boolean matches(String filename) {
        for (String current : this.getFilter().getExtensions()) {
            if (!FilenameUtils.wildcardMatch(filename, current, IOCase.INSENSITIVE)) continue;
            return true;
        }
        return false;
    }
}

