/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.io.AddPdfVersionConstraintEvent;
import org.pdfsam.ui.io.RemovePdfVersionConstraintEvent;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.model.pdf.PdfVersion;

class PdfVersionConstrainedCheckBox
extends CheckBox
implements ModuleOwned {
    private PdfVersion constraint;
    private String ownerModule = "";

    public PdfVersionConstrainedCheckBox(PdfVersion constraint, String ownerModule) {
        RequireUtils.requireNotNull(constraint, "PdfVersion cannot be null");
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.constraint = constraint;
        this.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("PDF version required: {0}", this.constraint.getVersionString())));
        this.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.selectedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                StaticStudio.eventStudio().broadcast(new AddPdfVersionConstraintEvent(constraint), ownerModule);
            } else {
                StaticStudio.eventStudio().broadcast(new RemovePdfVersionConstraintEvent(constraint), ownerModule);
            }
        });
        this.getStyleClass().addAll((Object[])Style.VITEM.css());
    }

    @Override
    public String getOwnerModule() {
        return this.ownerModule;
    }
}

