/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing.converter;

import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.input.style.keys.font.FontStyle;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontWeight;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class FontConverter
implements Converter {
    public ConverterAttributeSet convertToCSS(Object object, Object object2, ConverterAttributeSet converterAttributeSet, Element element) {
        if (object instanceof StyleConstants.FontConstants) {
            StyleConstants.FontConstants fontConstants = (StyleConstants.FontConstants)object;
            return this.handleFontConstants(fontConstants, object2);
        }
        return null;
    }

    protected ConverterAttributeSet handleFontConstants(StyleConstants.FontConstants fontConstants, Object object) {
        ConverterAttributeSet converterAttributeSet = new ConverterAttributeSet();
        if (fontConstants == StyleConstants.FontFamily) {
            converterAttributeSet.addAttribute(FontStyleKeys.FONT_FAMILY.getName(), object);
        } else if (fontConstants == StyleConstants.FontSize) {
            converterAttributeSet.addAttribute(FontStyleKeys.FONT_SIZE.getName(), object);
        } else if (fontConstants == StyleConstants.Bold) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                converterAttributeSet.addAttribute(FontStyleKeys.FONT_WEIGHT.getName(), FontWeight.BOLD);
            } else {
                converterAttributeSet.addAttribute(FontStyleKeys.FONT_WEIGHT.getName(), FontWeight.NORMAL);
            }
        } else if (fontConstants == StyleConstants.Italic) {
            Boolean bl = (Boolean)object;
            if (Boolean.TRUE.equals(bl)) {
                converterAttributeSet.addAttribute(FontStyleKeys.FONT_STYLE.getName(), FontStyle.ITALIC);
            } else {
                converterAttributeSet.addAttribute(FontStyleKeys.FONT_STYLE.getName(), FontStyle.NORMAL);
            }
        } else {
            DebugLog.log((Object)("Unkown type of font attribute: " + fontConstants));
            return null;
        }
        return converterAttributeSet;
    }
}

