/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.UrlRepository;
import org.pentaho.reporting.libraries.repository.file.FileContentLocation;

public class FileRepository
implements UrlRepository,
Serializable {
    private static final long serialVersionUID = -6221548332596506480L;
    private MimeRegistry mimeRegistry;
    private FileContentLocation root;

    public FileRepository(File file) throws ContentIOException {
        this(file, new DefaultMimeRegistry());
    }

    public FileRepository(File file, MimeRegistry mimeRegistry) throws ContentIOException {
        if (mimeRegistry == null) {
            throw new NullPointerException("MimeRegistry must be given");
        }
        if (file == null) {
            throw new NullPointerException("File must be given");
        }
        this.mimeRegistry = mimeRegistry;
        this.root = new FileContentLocation(this, file);
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public URL getURL() throws MalformedURLException {
        try {
            URI uri = this.root.getBackend().toURI();
            return uri.toURL();
        }
        catch (SecurityException e) {
            throw new MalformedURLException("impossible" + e);
        }
    }
}

