/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.awt.Color;

public class ColourConverter {
    private static final short BLACK = 0;
    private static final short SILVER = 1;
    private static final short GREY = 2;
    private static final short WHITE = 3;
    private static final short RED = 4;
    private static final short LIME = 5;
    private static final short BLUE = 6;
    private static final short AQUA = 7;
    private static final short FUCHSIA = 8;
    private static final short YELLOW = 9;
    private static final short MAROON = 10;
    private static final short GREEN = 11;
    private static final short NAVY = 12;
    private static final short TEAL = 13;
    private static final short PURPLE = 14;
    public static final short OLIVE = 15;
    private short[] tableLookup = null;

    public ColourConverter() {
    }

    public ColourConverter(short[] lookup) {
        this.tableLookup = lookup;
    }

    private short colourLookup(short colour) {
        if (this.tableLookup != null) {
            return this.tableLookup[colour];
        }
        return colour;
    }

    private short indexLookup(short index) {
        int result = 0;
        if (this.tableLookup != null) {
            for (int i = 0; i < this.tableLookup.length; i = (int)((short)(i + 1))) {
                if (this.tableLookup[i] != index) continue;
                result = i;
            }
        } else {
            result = index;
        }
        return (short)result;
    }

    public Color convertToRGB(short colour) {
        short index = this.indexLookup(colour);
        int r = 0;
        int g = 0;
        int b = 0;
        switch (index) {
            case 1: {
                b = 128;
                g = 128;
                r = 128;
                break;
            }
            case 2: {
                b = 192;
                g = 192;
                r = 192;
                break;
            }
            case 3: {
                b = 255;
                g = 255;
                r = 255;
                break;
            }
            case 4: {
                r = 255;
                break;
            }
            case 5: {
                g = 255;
                break;
            }
            case 6: {
                b = 255;
                break;
            }
            case 7: {
                b = 255;
                g = 255;
                break;
            }
            case 8: {
                b = 255;
                r = 255;
                break;
            }
            case 9: {
                g = 255;
                r = 255;
                break;
            }
            case 10: {
                r = 128;
                break;
            }
            case 11: {
                g = 128;
                break;
            }
            case 12: {
                b = 128;
                break;
            }
            case 13: {
                g = 128;
                b = 128;
                break;
            }
            case 14: {
                b = 128;
                r = 128;
                break;
            }
            case 15: {
                g = 128;
                r = 128;
                break;
            }
            default: {
                b = 0;
                g = 0;
                r = 0;
            }
        }
        return new Color(r, g, b);
    }

    public short convertFromRGB(Color colour) {
        int matchedRGB = 0;
        int indexColour = 0;
        int[] reducedMap = new int[]{0, 0, 128};
        int red = colour.getRed();
        int green = colour.getGreen();
        int blue = colour.getBlue();
        if (red > 192 && green > 192 && blue > 192) {
            if (red != 255) {
                red = this.getClosest(red, reducedMap);
            }
            if (green != 255) {
                green = this.getClosest(green, reducedMap);
            }
            if (blue != 255) {
                blue = this.getClosest(blue, reducedMap);
            }
        }
        matchedRGB += this.getClosest(red) << 16;
        matchedRGB += this.getClosest(green) << 8;
        if (((matchedRGB += this.getClosest(blue)) & 0xFF0000) == 0xFF0000 || (matchedRGB & 0xFF00) == 65280 || (matchedRGB & 0xFF) == 255) {
            if ((matchedRGB & 0xFF0000) == 0x800000) {
                matchedRGB ^= 0x800000;
            }
            if ((matchedRGB & 0xFF00) == 32768) {
                matchedRGB ^= 0x8000;
            }
            if ((matchedRGB & 0xFF) == 128) {
                matchedRGB ^= 0x80;
            }
        }
        switch (matchedRGB) {
            case 0: {
                indexColour = 0;
                break;
            }
            case 0x808080: {
                if (!this.isGrey(colour)) {
                    indexColour = 1;
                    break;
                }
                indexColour = 2;
                break;
            }
            case 0xFFFFFF: {
                if (!this.isGrey(colour)) {
                    indexColour = 3;
                    break;
                }
                indexColour = 2;
                break;
            }
            case 0xFF0000: {
                indexColour = 4;
                break;
            }
            case 65280: {
                indexColour = 5;
                break;
            }
            case 255: {
                indexColour = 6;
                break;
            }
            case 65535: {
                indexColour = 7;
                break;
            }
            case 0xFF00FF: {
                indexColour = 8;
                break;
            }
            case 0xFFFF00: {
                indexColour = 9;
                break;
            }
            case 0x800000: {
                indexColour = 10;
                break;
            }
            case 32768: {
                indexColour = 11;
                break;
            }
            case 128: {
                indexColour = 12;
                break;
            }
            case 32896: {
                indexColour = 13;
                break;
            }
            case 0x800080: {
                indexColour = 14;
                break;
            }
            case 0x808000: {
                indexColour = 15;
                break;
            }
            default: {
                indexColour = 0;
            }
        }
        return this.colourLookup((short)indexColour);
    }

    private int getClosest(int value) {
        int[] points = new int[]{0, 128, 255};
        return this.getClosest(value, points);
    }

    private int getClosest(int value, int[] points) {
        if (value == points[0] || value == points[1] || value == points[2]) {
            return value;
        }
        if (value < points[1]) {
            int x = value - points[0];
            return Math.round((float)x / (float)(points[1] - points[0])) == 1 ? points[1] : points[0];
        }
        int x = value - points[1];
        return Math.round((float)x / (float)(points[2] - points[1])) >= 1 ? points[2] : points[1];
    }

    private boolean isGrey(Color c) {
        int matchedRGB = 0;
        int[] points = new int[]{128, 192, 255};
        matchedRGB += this.getClosest(c.getRed(), points) << 16;
        matchedRGB += this.getClosest(c.getGreen(), points) << 8;
        return (matchedRGB += this.getClosest(c.getBlue(), points)) == 0xC0C0C0;
    }
}

