/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

public abstract class GeoPointArrayAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    @Override
    public void close() {
    }

    public static class Single
    extends GeoPointArrayAtomicFieldData {
        private final LongArray indexedPoint;
        private final BitSet set;

        public Single(LongArray indexedPoint, BitSet set) {
            this.indexedPoint = indexedPoint;
            this.set = set;
        }

        public long ramBytesUsed() {
            return 4L + this.indexedPoint.ramBytesUsed() + (this.set == null ? 0L : this.set.ramBytesUsed());
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable((String)"indexedPoints", (Accountable)this.indexedPoint));
            if (this.set != null) {
                resources.add(Accountables.namedAccountable((String)"missing bitset", (Accountable)this.set));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final GeoPoint point = new GeoPoint();
            GeoPointValues values = new GeoPointValues(){

                @Override
                public GeoPoint get(int docID) {
                    if (Single.this.set == null || Single.this.set.get(docID)) {
                        return point.resetFromIndexHash(Single.this.indexedPoint.get(docID));
                    }
                    return point.reset(Double.NaN, Double.NaN);
                }
            };
            return FieldData.singleton(values, (Bits)this.set);
        }
    }

    static class WithOrdinals
    extends GeoPointArrayAtomicFieldData {
        private final LongArray indexedPoints;
        private final Ordinals ordinals;
        private final int maxDoc;

        public WithOrdinals(LongArray indexedPoints, Ordinals ordinals, int maxDoc) {
            this.indexedPoints = indexedPoints;
            this.ordinals = ordinals;
            this.maxDoc = maxDoc;
        }

        public long ramBytesUsed() {
            return 4L + this.indexedPoints.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable((String)"indexedPoints", (Accountable)this.indexedPoints));
            return Collections.unmodifiableList(resources);
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final RandomAccessOrds ords = this.ordinals.ordinals();
            final SortedDocValues singleOrds = DocValues.unwrapSingleton((SortedSetDocValues)ords);
            final GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
            if (singleOrds != null) {
                GeoPointValues values = new GeoPointValues(){

                    @Override
                    public GeoPoint get(int docID) {
                        int ord = singleOrds.getOrd(docID);
                        if (ord >= 0) {
                            return point.resetFromIndexHash(WithOrdinals.this.indexedPoints.get(ord));
                        }
                        return point.reset(Double.NaN, Double.NaN);
                    }
                };
                return FieldData.singleton(values, DocValues.docsWithValue((SortedDocValues)singleOrds, (int)this.maxDoc));
            }
            return new MultiGeoPointValues(){

                @Override
                public GeoPoint valueAt(int index) {
                    return point.resetFromIndexHash(WithOrdinals.this.indexedPoints.get(ords.ordAt(index)));
                }

                @Override
                public void setDocument(int docId) {
                    ords.setDocument(docId);
                }

                @Override
                public int count() {
                    return ords.cardinality();
                }
            };
        }
    }
}

