/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.simpleframework.transport.reactor.Distributor;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.PartitionDistributor;
import org.simpleframework.transport.reactor.Reactor;

public class ExecutorReactor
implements Reactor {
    private final Distributor exchange;
    private final Executor executor;

    public ExecutorReactor(Executor executor) throws IOException {
        this(executor, 1);
    }

    public ExecutorReactor(Executor executor, int count) throws IOException {
        this(executor, count, 120000L);
    }

    public ExecutorReactor(Executor executor, int count, long expiry) throws IOException {
        this.exchange = new PartitionDistributor(executor, count, expiry);
        this.executor = executor;
    }

    public void process(Operation task) throws IOException {
        this.executor.execute(task);
    }

    public void process(Operation task, int require) throws IOException {
        this.exchange.process(task, require);
    }

    public void stop() throws IOException {
        this.exchange.close();
    }
}

