/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitRebaseLineListener;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        if (rebaseSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebaseSpec", "git4idea/rebase/GitRebaseProcess", "<init>"));
        }
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
    }

    public void rebase() {
        new GitFreezingProcess(this.myProject, this.myFacade, "rebase", new Runnable(){

            @Override
            public void run() {
                GitRebaseProcess.this.doRebase();
            }
        }).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap statuses = ContainerUtil.newLinkedHashMap(this.myRebaseSpec.getStatuses());
        LinkedHashSet toRefresh = ContainerUtilRt.newLinkedHashSet();
        List<GitRepository> repositoriesToRebase = this.myRebaseSpec.getIncompleteRepositories();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository failed = null;
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses));
                repository.update();
                statuses.put(repository, rebaseStatus);
                if (GitRebaseProcess.shouldBeRefreshed(rebaseStatus)) {
                    toRefresh.add(repository);
                }
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                failed = repository;
                break;
            }
            if (failed == null) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            GitRebaseProcess.refresh(toRefresh);
            if (failed == null) {
                this.notifySuccess(GitRebaseProcess.getSuccessfulRepositories(statuses), GitRebaseProcess.getSkippedCommits(statuses));
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/rebase/GitRebaseProcess", "saveUpdatedSpec"));
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result;
        MultiMap<GitRepository, GitRebaseUtils.CommitInfo> allSkippedCommits;
        ArrayList skippedCommits;
        String repoName;
        block19: {
            ResolveConflictResult resolveResult;
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
            }
            if (alreadyRebased == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyRebased", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
            }
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            skippedCommits = ContainerUtilRt.newArrayList();
            allSkippedCommits = GitRebaseProcess.getSkippedCommits(alreadyRebased);
            boolean retryWhenDirty = false;
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseLineListener progressListener = new GitRebaseLineListener();
                result = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                boolean bl = somethingRebased = customMode != null || progressListener.getResult().current > 1;
                if (result.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage(repository);
                        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                        if (gitRebaseStatus == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
                        }
                        return gitRebaseStatus;
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    GitSuccessfulRebase gitSuccessfulRebase = GitSuccessfulRebase.parseFromOutput(result.getOutput(), skippedCommits);
                    if (gitSuccessfulRebase == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
                    }
                    return gitSuccessfulRebase;
                }
                if (result.cancelled()) {
                    LOG.info("Rebase was cancelled");
                    throw new ProcessCanceledException();
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn("Couldn't " + this.mySaver.getOperationName() + " root " + repository.getRoot() + ": " + saveError);
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type2, skippedCommits);
                    if (gitRebaseStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
                    }
                    return gitRebaseStatus;
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
                    if (gitRebaseStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
                    }
                    return gitRebaseStatus;
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    GitRebaseUtils.CommitInfo currentRebaseCommit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                    if (currentRebaseCommit != null) {
                        skippedCommits.add(currentRebaseCommit);
                    }
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block19;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result.getErrorOutputAsJoinedString());
                this.showFatalError(result.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type3, skippedCommits);
                if (gitRebaseStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
                }
                return gitRebaseStatus;
            }
            this.notifyNotAllConflictsResolved(repository, allSkippedCommits);
            GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
            if (gitRebaseStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
            }
            return gitRebaseStatus;
        }
        LOG.info("Error rebasing root " + repoName + ": " + result.getErrorOutputAsJoinedString());
        this.showFatalError(result.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
        if (gitRebaseStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "rebaseSingleRoot"));
        }
        return gitRebaseStatus;
    }

    @NotNull
    private GitCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess", "callRebase"));
        }
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "git4idea/rebase/GitRebaseProcess", "callRebase"));
        }
        if (mode == null) {
            GitRebaseParams params = (GitRebaseParams)ObjectUtils.assertNotNull((Object)this.myRebaseSpec.getParams());
            GitCommandResult gitCommandResult = this.myGit.rebase(repository, params, listeners);
            if (gitCommandResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "callRebase"));
            }
            return gitCommandResult;
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            GitCommandResult gitCommandResult = this.myGit.rebaseSkip(repository, listeners);
            if (gitCommandResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "callRebase"));
            }
            return gitCommandResult;
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + (Object)((Object)mode)));
        GitCommandResult gitCommandResult = this.myGit.rebaseContinue(repository, listeners);
        if (gitCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "callRebase"));
        }
        return gitCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "getDirtyRoots"));
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "getDirtyRoots"));
        }
        return collection;
    }

    private static boolean shouldBeRefreshed(@NotNull GitRebaseStatus rebaseStatus) {
        if (rebaseStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebaseStatus", "git4idea/rebase/GitRebaseProcess", "shouldBeRefreshed"));
        }
        return rebaseStatus.getType() != GitRebaseStatus.Type.SUCCESS || ((GitSuccessfulRebase)rebaseStatus).getSuccessType() != GitSuccessfulRebase.SuccessType.UP_TO_DATE;
    }

    private static void refresh(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "refresh"));
        }
        GitUtil.updateRepositories(repositories);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(GitUtil.getRootsFromRepositories(repositories)));
    }

    private boolean saveDirtyRootsInitially(@NotNull List<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "saveDirtyRootsInitially"));
        }
        List repositoriesToSave = ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return !repository.equals(GitRebaseProcess.this.myRebaseSpec.getOngoingRebase());
            }
        });
        if (repositoriesToSave.isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("Rebase not Started", error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToSave", "git4idea/rebase/GitRebaseProcess", "saveLocalChanges"));
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return "Couldn't " + this.mySaver.getSaverName() + " local uncommitted changes:<br/>" + e.getMessage();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "findRootsWithLocalChanges"));
        }
        return ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return GitRebaseProcess.this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO;
            }
        });
    }

    private void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String baseBranch;
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "notifySuccess"));
        }
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        List successTypes = ContainerUtil.map(successful.values(), (Function)new Function<GitSuccessfulRebase, GitSuccessfulRebase.SuccessType>(){

            public GitSuccessfulRebase.SuccessType fun(@NotNull GitSuccessfulRebase rebase) {
                if (rebase == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rebase", "git4idea/rebase/GitRebaseProcess$4", "fun"));
                }
                return rebase.getSuccessType();
            }
        });
        GitSuccessfulRebase.SuccessType commonType = GitRebaseProcess.getItemIfAllTheSame(successTypes, GitSuccessfulRebase.SuccessType.REBASED);
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = baseBranch = params == null ? null : (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = commonType.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        message = message + GitRebaseProcess.mentionSkippedCommits(skippedCommits);
        this.myNotifier.notifyMinorInfo("Rebase Successful", message, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/rebase/GitRebaseProcess$5", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/rebase/GitRebaseProcess$5", "hyperlinkActivated"));
                }
                GitRebaseProcess.this.handlePossibleCommitLinks(e.getDescription(), (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)skippedCommits);
            }
        });
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseProcess", "getCommonCurrentBranchNameIfAllTheSame"));
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, (Function)new Function<GitRepository, String>(){

            public String fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess$6", "fun"));
                }
                return repository.getCurrentBranchName();
            }
        }), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "git4idea/rebase/GitRebaseProcess", "getItemIfAllTheSame"));
        }
        return (T)(ContainerUtil.newHashSet(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (conflictingRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictingRepository", "git4idea/rebase/GitRebaseProcess", "notifyNotAllConflictsResolved"));
        }
        String description = "You have to <a href='resolve'>resolve</a> the conflicts and <a href='continue'>continue</a> rebase.<br/>If you want to start from the beginning, you can <a href='abort'>abort</a> rebase.";
        description = description + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        this.myNotifier.notifyImportantWarning("Rebase Suspended", description, (NotificationListener)new RebaseNotificationListener(conflictingRepository, skippedCommits));
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicting", "git4idea/rebase/GitRebaseProcess", "showConflictResolver"));
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, this.myGit, this.myFacade, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "showConflictResolver"));
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "showConflictResolver"));
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "showConflictResolver"));
        }
        return resolveConflictResult;
    }

    private void showStoppedForEditingMessage(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess", "showStoppedForEditingMessage"));
        }
        String description = "Once you are satisfied with your changes you may <a href='continue'>continue</a>";
        this.myNotifier.notifyImportantInfo("Rebase Stopped for Editing", description, (NotificationListener)new RebaseNotificationListener(repository, (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)MultiMap.empty()));
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitRebaseProcess", "showFatalError"));
        }
        String repo = this.myRepositoryManager.moreThanOneRoot() ? DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": " : "";
        String description = repo + error + "<br/>" + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        String title = this.myRebaseSpec.getOngoingRebase() == null ? "Rebase Failed" : "Continue Rebase Failed";
        this.myNotifier.notifyError(title, description, (NotificationListener)new RebaseNotificationListener(currentRepository, skippedCommits));
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (untrackedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "untrackedPaths", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "showUntrackedFilesError"));
        }
        String message = GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription("rebase", true) + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, "rebase", message);
    }

    @NotNull
    private static String mentionRetryAndAbort(boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (successful == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successful", "git4idea/rebase/GitRebaseProcess", "mentionRetryAndAbort"));
        }
        String string = somethingWasRebased || !successful.isEmpty() ? "You can <a href='retry'>retry</a> or <a href='abort'>abort</a> rebase." : "<a href='retry'>Retry.</a>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionRetryAndAbort"));
        }
        return string;
    }

    @NotNull
    private static String mentionSkippedCommits(@NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitRebaseProcess", "mentionSkippedCommits"));
        }
        if (skippedCommits.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionSkippedCommits"));
            }
            return "";
        }
        String message = "<br/>";
        message = skippedCommits.values().size() == 1 ? message + "The following commit was skipped during rebase:<br/>" : message + "The following commits were skipped during rebase:<br/>";
        String string = message = message + StringUtil.join((Collection)skippedCommits.values(), (Function)new Function<GitRebaseUtils.CommitInfo, String>(){

            public String fun(@NotNull GitRebaseUtils.CommitInfo commitInfo) {
                if (commitInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitInfo", "git4idea/rebase/GitRebaseProcess$7", "fun"));
                }
                String commitMessage = StringUtil.shortenPathWithEllipsis((String)commitInfo.subject, (int)72, (boolean)true);
                String hash = commitInfo.revision.asString();
                String shortHash = DvcsUtil.getShortHash((String)commitInfo.revision.asString());
                return String.format("<a href='%s'>%s</a> %s", hash, shortHash, commitMessage);
            }
        }, (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "mentionSkippedCommits"));
        }
        return string;
    }

    @NotNull
    private static MultiMap<GitRepository, GitRebaseUtils.CommitInfo> getSkippedCommits(@NotNull Map<GitRepository, ? extends GitRebaseStatus> statuses) {
        if (statuses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/rebase/GitRebaseProcess", "getSkippedCommits"));
        }
        MultiMap map = MultiMap.create();
        for (GitRepository repository : statuses.keySet()) {
            map.put((Object)repository, statuses.get(repository).getSkippedCommits());
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "getSkippedCommits"));
        }
        return multiMap;
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/rebase/GitRebaseProcess", "getSuccessfulRepositories"));
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map.put(repository, (GitSuccessfulRebase)status);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseProcess", "getSuccessfulRepositories"));
        }
        return linkedHashMap;
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, "Aborting Rebase Process..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$8", "run"));
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }
        });
    }

    private void retry(@NotNull String processTitle) {
        if (processTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processTitle", "git4idea/rebase/GitRebaseProcess", "retry"));
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$9", "run"));
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }
        });
    }

    private void handlePossibleCommitLinks(@NotNull String href, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (href == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "href", "git4idea/rebase/GitRebaseProcess", "handlePossibleCommitLinks"));
        }
        GitRepository repository = GitRebaseProcess.findRootBySkippedCommit(href, skippedCommits);
        if (repository != null) {
            GitUtil.showSubmittedFiles(this.myProject, href, repository.getRoot(), true, false);
        }
    }

    @Nullable
    private static GitRepository findRootBySkippedCommit(final @NotNull String hash, final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/rebase/GitRebaseProcess", "findRootBySkippedCommit"));
        }
        return (GitRepository)ContainerUtil.find((Iterable)skippedCommits.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return ContainerUtil.exists((Iterable)skippedCommits.get((Object)repository), (Condition)new Condition<GitRebaseUtils.CommitInfo>(){

                    public boolean value(GitRebaseUtils.CommitInfo info) {
                        return info.revision.asString().equals(hash);
                    }
                });
            }
        });
    }

    private class RebaseNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final GitRepository myCurrentRepository;
        @NotNull
        private final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> mySkippedCommits;

        RebaseNotificationListener(@NotNull GitRepository currentRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            if (currentRepository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "<init>"));
            }
            if (skippedCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "<init>"));
            }
            this.myCurrentRepository = currentRepository;
            this.mySkippedCommits = skippedCommits;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener", "hyperlinkActivated"));
            }
            String href = e.getDescription();
            if ("abort".equals(href)) {
                GitRebaseProcess.this.abort();
            } else if ("continue".equals(href)) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            } else if ("retry".equals(href)) {
                GitRebaseProcess.this.retry("Retry Rebase Process...");
            } else if ("resolve".equals(href)) {
                GitRebaseProcess.this.showConflictResolver(this.myCurrentRepository, true);
            } else if ("stash".equals(href)) {
                GitRebaseProcess.this.mySaver.showSavedChanges();
            } else {
                GitRebaseProcess.this.handlePossibleCommitLinks(href, (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)this.mySkippedCommits);
            }
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade platformFacade, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (platformFacade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver", "<init>"));
            }
            super(project, git, platformFacade, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() throws VcsException {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() throws VcsException {
            this.myWasNothingToMerge = true;
            return true;
        }
    }
}

