/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakHashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myPackageCoverageInfos = new HashMap();
    private final Map<String, PackageAnnotator.PackageCoverageInfo> myFlattenPackageCoverageInfos = new HashMap();
    private final Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> myDirCoverageInfos = new HashMap();
    private final Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> myTestDirCoverageInfos = new HashMap();
    private final Map<String, PackageAnnotator.ClassCoverageInfo> myClassCoverageInfos = new HashMap();
    private final WeakHashMap<PsiElement, PackageAnnotator.SummaryCoverageInfo> myExtensionCoverageInfos = new WeakHashMap();

    public JavaCoverageAnnotator(Project project) {
        super(project);
    }

    public static JavaCoverageAnnotator getInstance(Project project) {
        return (JavaCoverageAnnotator)ServiceManager.getService((Project)project, JavaCoverageAnnotator.class);
    }

    @Override
    @Nullable
    public String getDirCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager coverageDataManager) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/coverage/JavaCoverageAnnotator", "getDirCoverageInformationString"));
        }
        if (currentSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuite", "com/intellij/coverage/JavaCoverageAnnotator", "getDirCoverageInformationString"));
        }
        if (coverageDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataManager", "com/intellij/coverage/JavaCoverageAnnotator", "getDirCoverageInformationString"));
        }
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex();
        VirtualFile virtualFile = directory.getVirtualFile();
        boolean isInTestContent = projectFileIndex.isInTestSourceContent(virtualFile);
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        return isInTestContent ? JavaCoverageAnnotator.getCoverageInformationString(this.myTestDirCoverageInfos.get(virtualFile), coverageDataManager.isSubCoverageActive()) : JavaCoverageAnnotator.getCoverageInformationString(this.myDirCoverageInfos.get(virtualFile), coverageDataManager.isSubCoverageActive());
    }

    @Override
    @Nullable
    public String getFileCoverageInformationString(@NotNull PsiFile file, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coverage/JavaCoverageAnnotator", "getFileCoverageInformationString"));
        }
        if (currentSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSuite", "com/intellij/coverage/JavaCoverageAnnotator", "getFileCoverageInformationString"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/coverage/JavaCoverageAnnotator", "getFileCoverageInformationString"));
        }
        return null;
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myPackageCoverageInfos.clear();
        this.myFlattenPackageCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myClassCoverageInfos.clear();
        this.myExtensionCoverageInfos.clear();
    }

    @Override
    protected Runnable createRenewRequest(final @NotNull CoverageSuitesBundle suite, final @NotNull CoverageDataManager dataManager) {
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/coverage/JavaCoverageAnnotator", "createRenewRequest"));
        }
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataManager", "com/intellij/coverage/JavaCoverageAnnotator", "createRenewRequest"));
        }
        final Project project = this.getProject();
        final ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        final ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            classes.addAll(javaSuite.getCurrentSuiteClasses(project));
            packages.addAll(javaSuite.getCurrentSuitePackages(project));
        }
        if (packages.isEmpty() && classes.isEmpty()) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                final PackageAnnotator.Annotator annotator = new PackageAnnotator.Annotator(){

                    @Override
                    public void annotatePackage(String packageQualifiedName, PackageAnnotator.PackageCoverageInfo packageCoverageInfo) {
                        JavaCoverageAnnotator.this.myPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
                    }

                    @Override
                    public void annotatePackage(String packageQualifiedName, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, boolean flatten) {
                        if (flatten) {
                            JavaCoverageAnnotator.this.myFlattenPackageCoverageInfos.put(packageQualifiedName, packageCoverageInfo);
                        } else {
                            this.annotatePackage(packageQualifiedName, packageCoverageInfo);
                        }
                    }

                    @Override
                    public void annotateSourceDirectory(VirtualFile dir, PackageAnnotator.PackageCoverageInfo dirCoverageInfo, Module module) {
                        JavaCoverageAnnotator.this.myDirCoverageInfos.put(dir, dirCoverageInfo);
                    }

                    @Override
                    public void annotateTestDirectory(VirtualFile virtualFile, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, Module module) {
                        JavaCoverageAnnotator.this.myTestDirCoverageInfos.put(virtualFile, packageCoverageInfo);
                    }

                    @Override
                    public void annotateClass(String classQualifiedName, PackageAnnotator.ClassCoverageInfo classCoverageInfo) {
                        JavaCoverageAnnotator.this.myClassCoverageInfos.put(classQualifiedName, classCoverageInfo);
                    }
                };
                for (PsiPackage aPackage : packages) {
                    new PackageAnnotator(aPackage).annotate(suite, annotator);
                }
                for (final PsiClass aClass : classes) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String packageName = ((PsiClassOwner)aClass.getContainingFile()).getPackageName();
                            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
                            if (psiPackage == null) {
                                return;
                            }
                            new PackageAnnotator(psiPackage).annotateFilteredClass(aClass, suite, annotator);
                        }
                    };
                    ApplicationManager.getApplication().runReadAction(runnable);
                }
                dataManager.triggerPresentationUpdate();
            }
        };
    }

    @Nullable
    public static String getCoverageInformationString(PackageAnnotator.SummaryCoverageInfo info, boolean subCoverageActive) {
        if (info == null) {
            return null;
        }
        if (info.totalClassCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (subCoverageActive) {
            return info.coveredClassCount + info.getCoveredLineCount() > 0 ? "covered" : null;
        }
        return (int)((double)info.coveredClassCount / (double)info.totalClassCount * 100.0) + "% classes, " + (int)((double)info.getCoveredLineCount() / (double)info.totalLineCount * 100.0) + "% lines covered";
    }

    @Nullable
    public String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager) {
        if (coverageDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataManager", "com/intellij/coverage/JavaCoverageAnnotator", "getPackageCoverageInformationString"));
        }
        return this.getPackageCoverageInformationString(psiPackage, module, coverageDataManager, false);
    }

    @Nullable
    public String getPackageCoverageInformationString(PsiPackage psiPackage, @Nullable Module module, @NotNull CoverageDataManager coverageDataManager, boolean flatten) {
        if (coverageDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataManager", "com/intellij/coverage/JavaCoverageAnnotator", "getPackageCoverageInformationString"));
        }
        if (psiPackage == null) {
            return null;
        }
        boolean subCoverageActive = coverageDataManager.isSubCoverageActive();
        if (module != null) {
            PsiDirectory[] directories = psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
            PackageAnnotator.SummaryCoverageInfo result = null;
            for (PsiDirectory directory : directories) {
                VirtualFile virtualFile = directory.getVirtualFile();
                result = JavaCoverageAnnotator.merge(result, this.myDirCoverageInfos.get(virtualFile));
                result = JavaCoverageAnnotator.merge(result, this.myTestDirCoverageInfos.get(virtualFile));
            }
            return JavaCoverageAnnotator.getCoverageInformationString(result, subCoverageActive);
        }
        PackageAnnotator.PackageCoverageInfo info = this.getPackageCoverageInfo(psiPackage, flatten);
        return JavaCoverageAnnotator.getCoverageInformationString(info, subCoverageActive);
    }

    public PackageAnnotator.PackageCoverageInfo getPackageCoverageInfo(@NotNull PsiPackage psiPackage, boolean flattenPackages) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/coverage/JavaCoverageAnnotator", "getPackageCoverageInfo"));
        }
        String qualifiedName = psiPackage.getQualifiedName();
        return flattenPackages ? this.myFlattenPackageCoverageInfos.get(qualifiedName) : this.myPackageCoverageInfos.get(qualifiedName);
    }

    public String getLineCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.getCoveredLineCount(), info.totalLineCount);
    }

    public String getMethodCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredMethodCount, info.totalMethodCount);
    }

    public String getClassCoveredPercentage(@Nullable PackageAnnotator.SummaryCoverageInfo info) {
        if (info == null) {
            return null;
        }
        return JavaCoverageAnnotator.getPercentage(info.coveredClassCount, info.totalClassCount);
    }

    private static String getPercentage(int covered, int total) {
        return (int)((double)covered / (double)total * 100.0) + "% (" + covered + "/" + total + ")";
    }

    public static PackageAnnotator.SummaryCoverageInfo merge(@Nullable PackageAnnotator.SummaryCoverageInfo info, @Nullable PackageAnnotator.SummaryCoverageInfo testInfo) {
        if (info == null) {
            return testInfo;
        }
        if (testInfo == null) {
            return info;
        }
        PackageAnnotator.PackageCoverageInfo coverageInfo = new PackageAnnotator.PackageCoverageInfo();
        coverageInfo.totalClassCount = info.totalClassCount + testInfo.totalClassCount;
        coverageInfo.coveredClassCount = info.coveredClassCount + testInfo.coveredClassCount;
        coverageInfo.totalLineCount = info.totalLineCount + testInfo.totalLineCount;
        coverageInfo.coveredLineCount = info.getCoveredLineCount() + testInfo.getCoveredLineCount();
        return coverageInfo;
    }

    @Nullable
    public String getClassCoverageInformationString(String classFQName, CoverageDataManager coverageDataManager) {
        PackageAnnotator.ClassCoverageInfo info = this.myClassCoverageInfos.get(classFQName);
        if (info == null) {
            return null;
        }
        if (info.totalMethodCount == 0 || info.totalLineCount == 0) {
            return null;
        }
        if (coverageDataManager.isSubCoverageActive()) {
            return info.coveredMethodCount + info.fullyCoveredLineCount + info.partiallyCoveredLineCount > 0 ? "covered" : null;
        }
        return (int)((double)info.coveredMethodCount / (double)info.totalMethodCount * 100.0) + "% methods, " + (int)((double)(info.fullyCoveredLineCount + info.partiallyCoveredLineCount) / (double)info.totalLineCount * 100.0) + "% lines covered";
    }

    @Nullable
    public PackageAnnotator.ClassCoverageInfo getClassCoverageInfo(String classFQName) {
        return this.myClassCoverageInfos.get(classFQName);
    }

    public PackageAnnotator.SummaryCoverageInfo getExtensionCoverageInfo(PsiNamedElement value) {
        PackageAnnotator.SummaryCoverageInfo cachedInfo = (PackageAnnotator.SummaryCoverageInfo)this.myExtensionCoverageInfos.get((Object)value);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
            PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(this, value);
            if (info == null) continue;
            this.myExtensionCoverageInfos.put((Object)value, (Object)info);
            return info;
        }
        return null;
    }
}

