/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.ManageCodeStyleSchemesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel {
    private JComboBox myCombo;
    private final CodeStyleSchemesModel myModel;
    private JPanel myPanel;
    private JButton myManageButton;
    private boolean myIsReset = false;
    private final Font myDefaultComboFont;
    private final Font myBoldComboFont;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model) {
        this.myModel = model;
        this.$$$setupUI$$$();
        this.myDefaultComboFont = this.myCombo.getFont();
        this.myBoldComboFont = this.myDefaultComboFont.deriveFont(1);
        this.myCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1", "actionPerformed"));
                }
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CodeStyleSchemesPanel.this.onCombo();
                        }
                    });
                }
            }
        });
        this.myCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                CodeStyleScheme scheme;
                Font font = CodeStyleSchemesPanel.this.myDefaultComboFont;
                if (value instanceof CodeStyleScheme && ((scheme = (CodeStyleScheme)value).isDefault() || CodeStyleSchemesPanel.this.myModel.isProjectScheme(scheme))) {
                    font = CodeStyleSchemesPanel.this.myBoldComboFont;
                }
                this.setFont(font);
            }
        });
        this.myManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$3", "actionPerformed"));
                }
                CodeStyleSchemesPanel.this.showManageSchemesDialog();
            }
        });
    }

    private void onCombo() {
        CodeStyleScheme selected = this.getSelectedScheme();
        if (selected != null) {
            if (this.myModel.isProjectScheme(selected)) {
                this.myModel.setUsePerProjectSettings(true);
            } else {
                this.myModel.selectScheme(selected, this);
                this.myModel.setUsePerProjectSettings(false);
            }
        }
    }

    @Nullable
    private CodeStyleScheme getSelectedScheme() {
        Object selected = this.myCombo.getSelectedItem();
        if (selected instanceof CodeStyleScheme) {
            return (CodeStyleScheme)selected;
        }
        return null;
    }

    public void disposeUIResources() {
        this.myPanel.removeAll();
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
            schemes.addAll(this.myModel.getAllSortedSchemes());
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(schemes.toArray());
            this.myCombo.setModel(model);
            if (this.myModel.isUsePerProjectSettings()) {
                this.myCombo.setSelectedItem(this.myModel.getProjectScheme());
            } else {
                this.myCombo.setSelectedItem(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            if (this.myModel.isUsePerProjectSettings()) {
                this.myCombo.setSelectedItem(this.myModel.getProjectScheme());
            } else {
                this.myCombo.setSelectedItem(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private void showManageSchemesDialog() {
        ManageCodeStyleSchemesDialog manageSchemesDialog = new ManageCodeStyleSchemesDialog(this.myPanel, this.myModel);
        manageSchemesDialog.show();
    }

    public void usePerProjectSettingsOptionChanged() {
        if (this.myModel.isProjectScheme(this.myModel.getSelectedScheme())) {
            this.myCombo.setSelectedItem(this.myModel.getProjectScheme());
        } else {
            this.myCombo.setSelectedItem(this.myModel.getSelectedScheme());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 5, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.scheme.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        this.myManageButton = jButton = new JButton();
        jButton.setText("Manage...");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

