/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.SlowLineMarkersPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlowLineMarkersPassFactory
extends AbstractProjectComponent
implements DirtyScopeTrackingHighlightingPassFactory {
    public SlowLineMarkersPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, 6);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("SlowLineMarkersPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SlowLineMarkersPassFactory", "getComponentName"));
        }
        return "SlowLineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/SlowLineMarkersPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/SlowLineMarkersPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = SlowLineMarkersPassFactory.calculateRangeToProcess(editor);
        if (textRange == null) {
            return null;
        }
        return new SlowLineMarkersPass(this.myProject, file2, editor, textRange);
    }

    private static TextRange calculateRangeToProcess(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 6);
    }

    @Override
    public int getPassId() {
        return 6;
    }
}

