/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AwtVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TrafficProgressPanel
extends JPanel {
    static final String MAX_TEXT = "100%";
    private static final String MIN_TEXT = "0%";
    private final JLabel statistics;
    private final Map<JProgressBar, JLabel> myProgressToText;
    private final JLabel statusLabel;
    private final JLabel statusExtraLineLabel;
    @NotNull
    private final TrafficLightRenderer myTrafficLightRenderer;
    private final JPanel myPassStatuses;
    private final JPanel myEmptyPassStatuses;
    private final Wrapper myPassStatusesContainer;
    @NotNull
    private final HintHint myHintHint;

    TrafficProgressPanel(@NotNull TrafficLightRenderer trafficLightRenderer, @NotNull Editor editor, @NotNull HintHint hintHint) {
        if (trafficLightRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trafficLightRenderer", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "<init>"));
        }
        this.statistics = new JLabel();
        this.myProgressToText = new HashMap();
        this.statusLabel = new JLabel();
        this.statusExtraLineLabel = new JLabel();
        this.myPassStatuses = new JPanel();
        this.myEmptyPassStatuses = new NonOpaquePanel();
        this.myPassStatusesContainer = new Wrapper();
        this.myHintHint = hintHint;
        this.myTrafficLightRenderer = trafficLightRenderer;
        this.setLayout(new BorderLayout());
        VerticalBox center = new VerticalBox();
        this.add((Component)center, "North");
        center.add((Component)this.statusLabel);
        center.add((Component)this.statusExtraLineLabel);
        center.add((Component)((Object)new Separator()));
        center.add(Box.createVerticalStrut(6));
        TrafficLightRenderer.DaemonCodeAnalyzerStatus fakeStatusLargeEnough = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
        fakeStatusLargeEnough.errorCount = new int[]{1, 1, 1, 1};
        Project project2 = trafficLightRenderer.getProject();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        fakeStatusLargeEnough.passStati = new ArrayList<ProgressableTextEditorHighlightingPass>();
        for (int i = 0; i < 3; ++i) {
            fakeStatusLargeEnough.passStati.add(new ProgressableTextEditorHighlightingPass(project2, null, DaemonBundle.message((String)"pass.wolf", (Object[])new Object[0]), psiFile, editor, TextRange.EMPTY_RANGE, false, HighlightInfoProcessor.getEmpty()){

                @Override
                protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$1", "collectInformationWithProgress"));
                    }
                }

                @Override
                protected void applyInformationWithProgress() {
                }
            });
        }
        center.add((Component)this.myPassStatusesContainer);
        this.add((Component)this.statistics, "South");
        this.updatePanel(fakeStatusLargeEnough, true);
        hintHint.initStyle(this, true);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
    }

    int getMinWidth() {
        return Math.max(Math.max(Math.max(this.getLabelMinWidth(this.statistics), this.getLabelMinWidth(this.statusExtraLineLabel)), this.getLabelMinWidth(this.statusLabel)), this.getLabelMinWidth(new JLabel("<html><b>Slow inspections progress report long line</b></html>")));
    }

    private int getLabelMinWidth(@NotNull JLabel label) {
        Icon icon;
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "getLabelMinWidth"));
        }
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && StringUtil.isEmpty((String)text)) {
            return 0;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle(10000, 10000);
        SwingUtilities.layoutCompoundLabel(label, this.getFontMetrics(this.getFont()), text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap());
        return paintTextR.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePanel(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, boolean isFake) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "updatePanel"));
        }
        try {
            boolean needRebuild = this.myTrafficLightRenderer.updatePanel(status, this.myTrafficLightRenderer.getProject());
            this.statusLabel.setText(this.myTrafficLightRenderer.statusLabel);
            if (this.myTrafficLightRenderer.statusExtraLine == null) {
                this.statusExtraLineLabel.setVisible(false);
            } else {
                this.statusExtraLineLabel.setText(this.myTrafficLightRenderer.statusExtraLine);
                this.statusExtraLineLabel.setVisible(true);
            }
            this.myPassStatuses.setVisible(this.myTrafficLightRenderer.passStatusesVisible);
            this.statistics.setText(this.myTrafficLightRenderer.statistics);
            this.resetProgressBars(this.myTrafficLightRenderer.progressBarsEnabled, this.myTrafficLightRenderer.progressBarsCompleted);
            if (needRebuild) {
                this.rebuildPassesProgress(status);
            }
            for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
                double progress = pass.getProgress();
                Pair<JProgressBar, JLabel> pair = this.myTrafficLightRenderer.passes.get(pass);
                JProgressBar progressBar = (JProgressBar)pair.first;
                int percent = (int)Math.round(progress * 100.0);
                if (percent == 100 && !pass.isFinished()) {
                    percent = 99;
                }
                progressBar.setValue(percent);
                JLabel percentage = (JLabel)pair.second;
                percentage.setText(percent + "%");
            }
        }
        finally {
            if (isFake) {
                this.myEmptyPassStatuses.setPreferredSize(this.myPassStatuses.getPreferredSize());
                this.myPassStatusesContainer.setContent((JComponent)this.myEmptyPassStatuses);
            } else {
                this.myPassStatusesContainer.setContent((JComponent)this.myPassStatuses);
            }
        }
    }

    private void resetProgressBars(final boolean enabled, final @Nullable Boolean completed) {
        new AwtVisitor(this.myPassStatuses){

            public boolean visit(Component component) {
                if (component instanceof JProgressBar) {
                    JProgressBar progress = (JProgressBar)component;
                    progress.setEnabled(enabled);
                    if (completed != null) {
                        if (completed.booleanValue()) {
                            progress.setValue(100);
                            ((JLabel)TrafficProgressPanel.this.myProgressToText.get(progress)).setText(TrafficProgressPanel.MAX_TEXT);
                        } else {
                            progress.setValue(0);
                            ((JLabel)TrafficProgressPanel.this.myProgressToText.get(progress)).setText(TrafficProgressPanel.MIN_TEXT);
                        }
                    }
                }
                return false;
            }
        };
    }

    private void rebuildPassesProgress(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel", "rebuildPassesProgress"));
        }
        this.myPassStatuses.removeAll();
        this.myPassStatuses.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        for (ProgressableTextEditorHighlightingPass pass : status.passStati) {
            JLabel label = new JLabel(pass.getPresentableName() + ": ");
            label.setHorizontalTextPosition(4);
            Pair<JProgressBar, JLabel> pair = this.myTrafficLightRenderer.passes.get(pass);
            JProgressBar progressBar = (JProgressBar)pair.getFirst();
            progressBar.putClientProperty("JComponent.sizeVariant", "mini");
            JLabel percLabel = (JLabel)pair.getSecond();
            this.myProgressToText.put(progressBar, percLabel);
            c.gridx = 0;
            this.myPassStatuses.add((Component)label, c);
            c.gridx = 1;
            this.myPassStatuses.add((Component)progressBar, c);
            c.gridx = 2;
            c.weightx = 1.0;
            this.myPassStatuses.add((Component)percLabel, c);
            ++c.gridy;
        }
        this.myHintHint.initStyle(this.myPassStatuses, true);
    }

    private class Separator
    extends NonOpaquePanel {
        private Separator() {
        }

        protected void paintComponent(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "paintComponent"));
            }
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            g.setColor(TrafficProgressPanel.this.myHintHint.getTextForeground());
            g.drawLine(insets.left, insets.top, this.getWidth() - insets.left - insets.right, insets.top);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(1, 1);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "getPreferredSize"));
            }
            return dimension;
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(1, 1);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficProgressPanel$Separator", "getMinimumSize"));
            }
            return dimension;
        }
    }
}

