/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import org.jetbrains.annotations.NotNull;

public class ChangeExtendsToImplementsFix
extends ExtendsListFix {
    private final String myName;

    public ChangeExtendsToImplementsFix(@NotNull PsiClass aClass, @NotNull PsiClassType classToExtendFrom) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeExtendsToImplementsFix", "<init>"));
        }
        if (classToExtendFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToExtendFrom", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeExtendsToImplementsFix", "<init>"));
        }
        super(aClass, classToExtendFrom, true);
        this.myName = this.myClassToExtendFrom == null ? this.getFamilyName() : QuickFixBundle.message("exchange.extends.implements.keyword", aClass.isInterface() == this.myClassToExtendFrom.isInterface() ? "implements" : "extends", aClass.isInterface() == this.myClassToExtendFrom.isInterface() ? "extends" : "implements", this.myClassToExtendFrom.getName());
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeExtendsToImplementsFix", "getText"));
        }
        return string;
    }
}

